package com.unity3d.services.store.gpbl.bridges.billingclient

import com.unity3d.services.store.gpbl.BillingResultResponseCode
import com.unity3d.services.store.gpbl.listeners.BillingClientStateListener
import com.unity3d.services.store.gpbl.listeners.BillingInitializationListener
import com.unity3d.services.store.gpbl.listeners.ProductDetailsListener
import com.unity3d.services.store.gpbl.listeners.PurchasesResponseListener
import kotlinx.coroutines.flow.MutableStateFlow

abstract class BillingClientAdapter {
    internal val _isInitialized = MutableStateFlow(false)
    val isInitialized: Boolean
        get() = _isInitialized.value
    abstract fun initialize(billingInitializationListener: BillingInitializationListener)
    abstract fun startConnection(billingClientStateListener: BillingClientStateListener?)
    abstract fun isFeatureSupported(purchaseType: String?): BillingResultResponseCode?
    abstract fun isReady(): Boolean
    abstract fun queryPurchasesAsync(purchaseType: String?, purchasesResponseListener: PurchasesResponseListener?)
    abstract fun queryProductDetailsAsync(productId: String, productType: String, listener: ProductDetailsListener)
    abstract fun getAdapterVersion(): String
}