package com.unity3d.services.store.core.api;

import com.unity3d.services.ads.gmascar.handlers.WebViewErrorHandler;
import com.unity3d.services.core.misc.Utilities;
import com.unity3d.services.core.webview.bridge.WebViewCallback;
import com.unity3d.services.core.webview.bridge.WebViewExposed;
import com.unity3d.services.store.StoreError;
import com.unity3d.services.store.StoreEvent;
import com.unity3d.services.store.StoreMonitor;
import com.unity3d.services.store.core.StoreEventListenerFactory;
import com.unity3d.services.store.core.WebViewStoreExceptionHandler;

import org.json.JSONArray;
import org.json.JSONException;

import java.util.ArrayList;

public class Store {
	private static final WebViewStoreExceptionHandler WEB_VIEW_STORE_EXCEPTION_HANDLER = new WebViewStoreExceptionHandler(new WebViewErrorHandler());
	private static final StoreEventListenerFactory storeEventListenerFactory = Utilities.getService(StoreEventListenerFactory.class);
	private static final StoreMonitor storeMonitor = new StoreMonitor(WEB_VIEW_STORE_EXCEPTION_HANDLER);

	@WebViewExposed
	public static void initialize(WebViewCallback callback) {
		try {
			storeMonitor.initialize(storeEventListenerFactory.invoke());
			callback.invoke();
		} catch(Exception e) {
			callback.error(StoreError.UNKNOWN_ERROR, e.getMessage(), e.getClass().getName());
		}
	}

	@WebViewExposed
	public static void startPurchaseTracking(JSONArray purchaseTypes, WebViewCallback callback) {
		if(!storeMonitor.isInitialized()) {
			callback.error(StoreError.NOT_INITIALIZED);
			return;
		}

		ArrayList<String> purchaseTypeList = new ArrayList<>();

		try {
			for (int i = 0; i < purchaseTypes.length(); i++) {
				purchaseTypeList.add(purchaseTypes.getString(i));
			}
		} catch(JSONException e) {
			callback.error(StoreError.JSON_ERROR, e.getMessage());
			return;
		}

		storeMonitor.startPurchaseTracking(purchaseTypeList, storeEventListenerFactory.invoke(-1, true));
		callback.invoke();
	}

	@WebViewExposed
	public static void stopPurchaseTracking(WebViewCallback callback) {
		if(!storeMonitor.isInitialized()) {
			callback.error(StoreError.NOT_INITIALIZED);
			return;
		}

		storeMonitor.stopPurchaseTracking();
		callback.invoke();
	}

	@WebViewExposed
	public static void isFeatureSupported(final Integer operationId, final String purchaseType, WebViewCallback callback) {
		if(!storeMonitor.isInitialized()) {
			callback.error(StoreError.NOT_INITIALIZED);
			return;
		}

		new Thread(() -> storeMonitor.isFeatureSupported(operationId, purchaseType, storeEventListenerFactory.invoke(operationId))).start();

		callback.invoke();
	}

	@WebViewExposed
	public static void getPurchases(final Integer operationId, final String purchaseType, WebViewCallback callback) {
		if(!storeMonitor.isInitialized()) {
			callback.error(StoreError.NOT_INITIALIZED);
			return;
		}
		storeMonitor.getPurchases(operationId, purchaseType, storeEventListenerFactory.invoke(operationId));
		callback.invoke();
	}

	@WebViewExposed
	public static void getPurchaseHistory(final Integer operationId, final String purchaseType, final Integer maxPurchases, WebViewCallback callback) {
		if(!storeMonitor.isInitialized()) {
			callback.error(StoreError.NOT_INITIALIZED);
			return;
		}

		storeMonitor.getPurchaseHistory(operationId, purchaseType, maxPurchases, storeEventListenerFactory.invoke(operationId));
		callback.invoke();
	}

	@WebViewExposed
	public static void getSkuDetails(final Integer operationId, final String purchaseType, final JSONArray skuList, WebViewCallback callback) {
		if(!storeMonitor.isInitialized()) {
			callback.error(StoreError.NOT_INITIALIZED);
			return;
		}

		try {
			ArrayList<String> skuArray = new ArrayList<>();
			for(int i = 0; i < skuList.length(); i++) {
				skuArray.add(skuList.getString(i));
			}
			storeMonitor.getSkuDetails(operationId, purchaseType, skuArray, storeEventListenerFactory.invoke(operationId));
		} catch(JSONException exception) {
			WEB_VIEW_STORE_EXCEPTION_HANDLER.handleStoreException(StoreEvent.SKU_DETAILS_LIST_REQUEST_ERROR, operationId, exception);
		}

		callback.invoke();
	}
}
