package com.unity3d.ads.core.utils

import kotlinx.coroutines.CoroutineDispatcher
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.SupervisorJob
import kotlinx.coroutines.delay
import kotlinx.coroutines.isActive
import kotlinx.coroutines.launch

class CommonCoroutineTimer(
    private val dispatcher: CoroutineDispatcher,
) : CoroutineTimer {
    private val job = SupervisorJob()
    private val scope = CoroutineScope(dispatcher + job)

    override fun start(
        delayStartMillis: Long,
        repeatMillis: Long,
        action: () -> Unit
    ) = scope.launch(dispatcher) {
        delay(delayStartMillis)
        while (isActive) {
            action()
            delay(repeatMillis)
        }
    }
}