package com.unity3d.ads.core.domain.events

import com.unity3d.ads.core.data.repository.DeviceInfoRepository
import gatewayprotocol.v1.TransactionEventRequestOuterClass.StoreType
import gatewayprotocol.v1.TransactionEventRequestOuterClass.TransactionData
import gatewayprotocol.v1.TransactionEventRequestOuterClass.TransactionEventRequest
import gatewayprotocol.v1.TransactionEventRequestOuterClass.TransactionOrigin
import gatewayprotocol.v1.transactionEventRequest



internal class CommonGetTransactionRequest(
    private val deviceInfoRepository: DeviceInfoRepository
): GetTransactionRequest {
    override suspend operator fun invoke(
            transactionDataList: List<TransactionData>,
            googlePlayBillingLibraryVersion: String,
            transactionOrigin: TransactionOrigin
        ): TransactionEventRequest {
        return transactionEventRequest {
            staticDeviceInfo = deviceInfoRepository.staticDeviceInfo()
            dynamicDeviceInfo = deviceInfoRepository.dynamicDeviceInfo
            appStore = StoreType.STORE_TYPE_GOOGLE_PLAY
            this.googlePlayBillingLibraryVersion = googlePlayBillingLibraryVersion
            origin = transactionOrigin
            transactionData.addAll(
                transactionDataList
            )
        }
    }
}