package com.unity3d.ads.core.data.datasource

import android.content.Context
import com.unity3d.services.UnityAdsConstants.Preferences.PREF_KEY_UNITY_INSTALLATION_ID
import com.unity3d.services.UnityAdsConstants.Preferences.PREF_KEY_UNITY_MEGA_SESSION_ID
import com.unity3d.services.core.preferences.AndroidPreferences

/**
 * Helper class for obtaining UnityEngine Identifiers.
 */
class AndroidUnityInfoDataSource(applicationContext: Context) {

    private val prefName = "${applicationContext.packageName}.v2.playerprefs"

    /**
     * @return the Unity Installation Id if available
     */
    fun getUnityInstallationId(): String? {
        return getPlayerPrefId(PREF_KEY_UNITY_INSTALLATION_ID)
    }

    /**
     * @return the Unity Mega Session Id if available
     */
    fun getUnityMegaSessionId(): String? {
        return getPlayerPrefId(PREF_KEY_UNITY_MEGA_SESSION_ID)
    }

    private fun getPlayerPrefId(key: String): String? {
        return AndroidPreferences.getString(prefName, key)?.ifBlank { null }
    }
}