package com.unity3d.ads.core.domain

import com.google.protobuf.ByteString
import gatewayprotocol.v1.AdFormatOuterClass.AdFormat
import gatewayprotocol.v1.UniversalRequestKt.payload
import gatewayprotocol.v1.UniversalRequestOuterClass.UniversalRequest
import gatewayprotocol.v1.adPlayerConfigRequest

internal class AndroidGetAdPlayerConfigRequest(
    private val getUniversalRequestForPayLoad: GetUniversalRequestForPayLoad,
) : GetAdPlayerConfigRequest {
    override suspend fun invoke(
        placement: String,
        opportunityId: ByteString,
        configToken: ByteString,
        adFormat: AdFormat?
    ): UniversalRequest {
        val request = adPlayerConfigRequest {
            configurationToken = configToken
            placementId = placement
            // webviewVersion
            impressionOpportunityId = opportunityId
            adFormat?.let { this.adFormat = it }
        }
        val payload = payload {
            adPlayerConfigRequest = request
        }
        return getUniversalRequestForPayLoad(payload)
    }
}