package com.unity3d.services.ads.gmascar.utils

import com.unity3d.ads.AdFormat
import com.unity3d.ads.TokenConfiguration
import com.unity3d.ads.core.extensions.toUnityAdFormat
import com.unity3d.scar.adapter.common.scarads.UnityAdFormat
import com.unity3d.services.core.configuration.IExperiments

class ScarAdFormatProvider (
    val tokenConfiguration: TokenConfiguration?,
    val experiments: IExperiments
) : IScarAdFormatProvider {
    override fun buildAdFormatList(): List<UnityAdFormat> {
        val adFormats = mutableListOf<UnityAdFormat>()
        if (tokenConfiguration == null) {
            adFormats.apply {
                add(UnityAdFormat.REWARDED)
                add(UnityAdFormat.INTERSTITIAL)
                if (experiments.isScarBannerHbEnabled) {
                    add(UnityAdFormat.BANNER)
                }
            }
        } else {
            when (tokenConfiguration.adFormat) {
                AdFormat.BANNER -> if (experiments.isScarBannerHbEnabled) {
                    adFormats.add(UnityAdFormat.BANNER)
                }
                else -> adFormats.add(tokenConfiguration.adFormat.toUnityAdFormat())
            }
        }

        return adFormats
    }
}