package com.unity3d.ads.core.domain.events

import com.unity3d.ads.core.data.model.OperationType
import com.unity3d.ads.core.data.model.exception.GatewayException
import com.unity3d.ads.gatewayclient.GatewayClient
import com.unity3d.ads.gatewayclient.RequestPolicy
import gatewayprotocol.v1.UniversalRequestOuterClass.UniversalRequest

class UniversalRequestEventSender(
    private val gatewayClient: GatewayClient,
    private val handleGatewayEventResponse: HandleGatewayEventResponse,
    private val universalRequestTtlValidator: UniversalRequestTtlValidator
    ) {
    suspend operator fun invoke(universalRequest: UniversalRequest, requestPolicy: RequestPolicy) {
        // If the universal request is expired, we should not send it.
        if (!universalRequestTtlValidator(universalRequest, requestPolicy)) {
            return
        }

        val result = runCatching {
            gatewayClient.request(
                request = universalRequest,
                requestPolicy = requestPolicy,
                operationType = OperationType.UNIVERSAL_EVENT
            )
        }

        // If gateway client receives an error_text error, it will throw an GatewayException.
        // However, the job should succeed since the gateway is telling us to stop sending the request.
        if (result.exceptionOrNull() is GatewayException) {
            return
        }

        // If the gateway client receives a response, we should handle it.
        handleGatewayEventResponse(result.getOrThrow())

    }
}