/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.store;

import android.app.Application;
import com.unity3d.services.core.properties.ClientProperties;
import com.unity3d.services.store.StoreEvent;
import com.unity3d.services.store.core.StoreExceptionHandler;
import com.unity3d.services.store.core.StoreLifecycleListener;
import com.unity3d.services.store.gpbl.StoreBilling;
import com.unity3d.services.store.gpbl.listeners.BillingInitializationListener;
import com.unity3d.services.store.gpbl.listeners.FeatureSupportedListener;
import com.unity3d.services.store.gpbl.listeners.PurchaseHistoryResponseListener;
import com.unity3d.services.store.gpbl.listeners.PurchasesResponseListener;
import com.unity3d.services.store.gpbl.listeners.SkuDetailsResponseListener;
import com.unity3d.services.store.gpbl.listeners.StoreEventListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016J \u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0018\u001a\u00020\u0019J2\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0010\u0010\u001b\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0013\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010\u001f\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020!J \u0010\"\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010#\u001a\u00020$J&\u0010%\u001a\u00020\u000f2\u0016\u0010&\u001a\u0012\u0012\u0004\u0012\u00020\u00130'j\b\u0012\u0004\u0012\u00020\u0013`(2\u0006\u0010)\u001a\u00020*J\u0006\u0010+\u001a\u00020\u000fR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/unity3d/services/store/StoreMonitor;", "", "storeExceptionHandler", "Lcom/unity3d/services/store/core/StoreExceptionHandler;", "(Lcom/unity3d/services/store/core/StoreExceptionHandler;)V", "_isInitialized", "Lkotlinx/coroutines/flow/MutableStateFlow;", "", "isInitialized", "()Z", "storeBilling", "Lcom/unity3d/services/store/gpbl/StoreBilling;", "storeLifecycleListener", "Lcom/unity3d/services/store/core/StoreLifecycleListener;", "getPurchaseHistory", "", "operationId", "", "purchaseType", "", "maxPurchases", "purchaseHistoryResponseListener", "Lcom/unity3d/services/store/gpbl/listeners/PurchaseHistoryResponseListener;", "getPurchases", "purchasesResponseListener", "Lcom/unity3d/services/store/gpbl/listeners/PurchasesResponseListener;", "getSkuDetails", "skuList", "", "skuDetailsResponseListener", "Lcom/unity3d/services/store/gpbl/listeners/SkuDetailsResponseListener;", "initialize", "billingInitializationListener", "Lcom/unity3d/services/store/gpbl/listeners/BillingInitializationListener;", "isFeatureSupported", "featureSupportedListener", "Lcom/unity3d/services/store/gpbl/listeners/FeatureSupportedListener;", "startPurchaseTracking", "purchaseTypes", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "storeEventListener", "Lcom/unity3d/services/store/gpbl/listeners/StoreEventListener;", "stopPurchaseTracking", "unity-ads_release"})
public final class StoreMonitor {
    @NotNull
    private final StoreExceptionHandler storeExceptionHandler;
    @Nullable
    private StoreBilling storeBilling;
    @Nullable
    private StoreLifecycleListener storeLifecycleListener;
    @NotNull
    private final MutableStateFlow<Boolean> _isInitialized;

    public StoreMonitor(@NotNull StoreExceptionHandler storeExceptionHandler) {
        Intrinsics.checkNotNullParameter((Object)storeExceptionHandler, (String)"storeExceptionHandler");
        this.storeExceptionHandler = storeExceptionHandler;
        this._isInitialized = StateFlowKt.MutableStateFlow((Object)false);
    }

    public final boolean isInitialized() {
        return (Boolean)this._isInitialized.getValue();
    }

    public final void initialize(@NotNull BillingInitializationListener billingInitializationListener) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Intrinsics.checkNotNullParameter((Object)billingInitializationListener, (String)"billingInitializationListener");
        if (this.isInitialized()) {
            billingInitializationListener.onIsAlreadyInitialized();
            return;
        }
        StoreBilling storeBilling = this.storeBilling = new StoreBilling(ClientProperties.getApplicationContext(), billingInitializationListener);
        if (storeBilling != null) {
            storeBilling.initialize(billingInitializationListener);
        }
        this._isInitialized.setValue((Object)true);
    }

    public final int isFeatureSupported(int operationId, @Nullable String purchaseType, @NotNull FeatureSupportedListener featureSupportedListener) {
        Intrinsics.checkNotNullParameter((Object)featureSupportedListener, (String)"featureSupportedListener");
        int result2 = -1;
        try {
            StoreBilling storeBilling = this.storeBilling;
            result2 = storeBilling != null ? storeBilling.isFeatureSupported(purchaseType) : -1;
            featureSupportedListener.onFeatureSupported(result2);
        }
        catch (Exception exception) {
            this.storeExceptionHandler.handleStoreException(StoreEvent.IS_FEATURE_SUPPORTED_REQUEST_ERROR, operationId, exception);
        }
        return result2;
    }

    public final void getPurchases(int operationId, @Nullable String purchaseType, @NotNull PurchasesResponseListener purchasesResponseListener) {
        Intrinsics.checkNotNullParameter((Object)purchasesResponseListener, (String)"purchasesResponseListener");
        try {
            if (this.storeBilling == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            StoreBilling storeBilling = this.storeBilling;
            if (storeBilling != null) {
                storeBilling.getPurchases(purchaseType, purchasesResponseListener);
            }
        }
        catch (Exception exception) {
            this.storeExceptionHandler.handleStoreException(StoreEvent.PURCHASES_REQUEST_ERROR, operationId, exception);
        }
    }

    public final void getPurchaseHistory(int operationId, @Nullable String purchaseType, int maxPurchases, @NotNull PurchaseHistoryResponseListener purchaseHistoryResponseListener) {
        Intrinsics.checkNotNullParameter((Object)purchaseHistoryResponseListener, (String)"purchaseHistoryResponseListener");
        try {
            StoreBilling storeBilling = this.storeBilling;
            if (storeBilling != null) {
                storeBilling.getPurchaseHistory(purchaseType, maxPurchases, purchaseHistoryResponseListener);
            }
        }
        catch (Exception exception) {
            this.storeExceptionHandler.handleStoreException(StoreEvent.PURCHASE_HISTORY_LIST_REQUEST_ERROR, operationId, exception);
        }
    }

    public final void getSkuDetails(int operationId, @Nullable String purchaseType, @Nullable List<String> skuList, @NotNull SkuDetailsResponseListener skuDetailsResponseListener) {
        Intrinsics.checkNotNullParameter((Object)skuDetailsResponseListener, (String)"skuDetailsResponseListener");
        try {
            StoreBilling storeBilling = this.storeBilling;
            if (storeBilling != null) {
                storeBilling.getSkuDetails(purchaseType, skuList, skuDetailsResponseListener);
            }
        }
        catch (Exception exception) {
            this.storeExceptionHandler.handleStoreException(StoreEvent.SKU_DETAILS_LIST_REQUEST_ERROR, operationId, exception);
        }
    }

    public final void startPurchaseTracking(@NotNull ArrayList<String> purchaseTypes, @NotNull StoreEventListener storeEventListener) {
        Intrinsics.checkNotNullParameter(purchaseTypes, (String)"purchaseTypes");
        Intrinsics.checkNotNullParameter((Object)storeEventListener, (String)"storeEventListener");
        if (this.storeLifecycleListener != null) {
            this.stopPurchaseTracking();
        }
        StoreBilling storeBilling = this.storeBilling;
        Intrinsics.checkNotNull((Object)storeBilling);
        this.storeLifecycleListener = new StoreLifecycleListener(purchaseTypes, storeBilling, storeEventListener);
        ClientProperties.getApplication().registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.storeLifecycleListener);
    }

    public final void stopPurchaseTracking() {
        if (this.storeLifecycleListener != null) {
            ClientProperties.getApplication().unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.storeLifecycleListener);
            this.storeLifecycleListener = null;
        }
    }
}

