/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.webview;

import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.View;
import android.webkit.ValueCallback;
import android.webkit.WebSettings;
import androidx.core.graphics.Insets;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import androidx.webkit.WebViewCompat;
import androidx.webkit.WebViewFeature;
import com.unity3d.services.core.configuration.Experiments;
import com.unity3d.services.core.configuration.IExperiments;
import com.unity3d.services.core.di.IServiceComponent;
import com.unity3d.services.core.di.IServiceProvider;
import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.misc.Utilities;
import com.unity3d.services.core.misc.ViewUtilities;
import com.unity3d.services.core.request.metrics.SDKMetricsSender;
import com.unity3d.services.core.webview.WebViewMetricKt;
import com.unity3d.services.core.webview.bridge.IInvocationCallbackInvoker;
import com.unity3d.services.core.webview.bridge.IWebViewBridge;
import com.unity3d.services.core.webview.bridge.SharedInstances;
import com.unity3d.services.core.webview.bridge.WebViewBridgeInterface;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B7\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0016\u001a\u00020\u0017H\u0002J \u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u000e\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001aH\u0016R\u001b\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/unity3d/services/core/webview/WebView;", "Landroid/webkit/WebView;", "Lcom/unity3d/services/core/di/IServiceComponent;", "context", "Landroid/content/Context;", "shouldNotRequireGesturePlayback", "", "webViewBridge", "Lcom/unity3d/services/core/webview/bridge/IWebViewBridge;", "callbackInvoker", "Lcom/unity3d/services/core/webview/bridge/IInvocationCallbackInvoker;", "experiments", "Lcom/unity3d/services/core/configuration/IExperiments;", "(Landroid/content/Context;ZLcom/unity3d/services/core/webview/bridge/IWebViewBridge;Lcom/unity3d/services/core/webview/bridge/IInvocationCallbackInvoker;Lcom/unity3d/services/core/configuration/IExperiments;)V", "sdkMetricsSender", "Lcom/unity3d/services/core/request/metrics/SDKMetricsSender;", "getSdkMetricsSender", "()Lcom/unity3d/services/core/request/metrics/SDKMetricsSender;", "sdkMetricsSender$delegate", "Lkotlin/Lazy;", "webViewBridgeInterface", "Lcom/unity3d/services/core/webview/bridge/WebViewBridgeInterface;", "applySafeAreaInsets", "", "evaluateJavascript", "script", "", "resultCallback", "Landroid/webkit/ValueCallback;", "loadUrl", "url", "unity-ads_release"})
@SourceDebugExtension(value={"SMAP\nWebView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebView.kt\ncom/unity3d/services/core/webview/WebView\n+ 2 IServiceComponent.kt\ncom/unity3d/services/core/di/IServiceComponentKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,145:1\n29#2,5:146\n1#3:151\n*S KotlinDebug\n*F\n+ 1 WebView.kt\ncom/unity3d/services/core/webview/WebView\n*L\n35#1:146,5\n*E\n"})
public class WebView
extends android.webkit.WebView
implements IServiceComponent {
    @NotNull
    private final Lazy sdkMetricsSender$delegate;
    @NotNull
    private final WebViewBridgeInterface webViewBridgeInterface;

    @JvmOverloads
    public WebView(@NotNull Context context, boolean shouldNotRequireGesturePlayback, @NotNull IWebViewBridge webViewBridge2, @NotNull IInvocationCallbackInvoker callbackInvoker, @NotNull IExperiments experiments) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)webViewBridge2, (String)"webViewBridge");
        Intrinsics.checkNotNullParameter((Object)callbackInvoker, (String)"callbackInvoker");
        Intrinsics.checkNotNullParameter((Object)experiments, (String)"experiments");
        super(context);
        IServiceComponent $this$inject_u24default$iv = this;
        String named$iv = "";
        LazyThreadSafetyMode mode$iv = LazyThreadSafetyMode.NONE;
        boolean $i$f$inject = false;
        this.sdkMetricsSender$delegate = LazyKt.lazy((LazyThreadSafetyMode)mode$iv, (Function0)((Function0)new Function0<SDKMetricsSender>($this$inject_u24default$iv, named$iv){
            final /* synthetic */ IServiceComponent $this_inject;
            final /* synthetic */ String $named;
            {
                this.$this_inject = $receiver;
                this.$named = $named;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final SDKMetricsSender invoke() {
                void $this$get$iv;
                IServiceComponent iServiceComponent = this.$this_inject;
                String named$iv = this.$named;
                boolean $i$f$get = false;
                return $this$get$iv.getServiceProvider().getRegistry().getService(named$iv, Reflection.getOrCreateKotlinClass(SDKMetricsSender.class));
            }
        }));
        this.webViewBridgeInterface = new WebViewBridgeInterface(webViewBridge2, callbackInvoker);
        WebSettings $this$_init__u24lambda_u240 = this.getSettings();
        boolean bl = false;
        $this$_init__u24lambda_u240.setAllowFileAccessFromFileURLs(true);
        $this$_init__u24lambda_u240.setAllowUniversalAccessFromFileURLs(true);
        $this$_init__u24lambda_u240.setAllowFileAccess(true);
        $this$_init__u24lambda_u240.setBlockNetworkImage(false);
        $this$_init__u24lambda_u240.setBlockNetworkLoads(false);
        $this$_init__u24lambda_u240.setBuiltInZoomControls(false);
        $this$_init__u24lambda_u240.setCacheMode(2);
        $this$_init__u24lambda_u240.setDatabaseEnabled(false);
        $this$_init__u24lambda_u240.setDisplayZoomControls(false);
        $this$_init__u24lambda_u240.setDomStorageEnabled(false);
        $this$_init__u24lambda_u240.setEnableSmoothTransition(false);
        $this$_init__u24lambda_u240.setGeolocationEnabled(false);
        $this$_init__u24lambda_u240.setJavaScriptCanOpenWindowsAutomatically(false);
        $this$_init__u24lambda_u240.setJavaScriptEnabled(true);
        $this$_init__u24lambda_u240.setLightTouchEnabled(false);
        $this$_init__u24lambda_u240.setLoadWithOverviewMode(false);
        $this$_init__u24lambda_u240.setLoadsImagesAutomatically(true);
        $this$_init__u24lambda_u240.setMediaPlaybackRequiresUserGesture(false);
        if (Build.VERSION.SDK_INT >= 21) {
            $this$_init__u24lambda_u240.setMixedContentMode(1);
        }
        $this$_init__u24lambda_u240.setNeedInitialFocus(true);
        $this$_init__u24lambda_u240.setPluginState(WebSettings.PluginState.OFF);
        $this$_init__u24lambda_u240.setRenderPriority(WebSettings.RenderPriority.NORMAL);
        $this$_init__u24lambda_u240.setSaveFormData(false);
        $this$_init__u24lambda_u240.setSavePassword(false);
        $this$_init__u24lambda_u240.setSupportMultipleWindows(false);
        $this$_init__u24lambda_u240.setSupportZoom(false);
        $this$_init__u24lambda_u240.setUseWideViewPort(true);
        $this$_init__u24lambda_u240.setMediaPlaybackRequiresUserGesture(!shouldNotRequireGesturePlayback);
        this.setHorizontalScrollBarEnabled(false);
        this.setVerticalScrollBarEnabled(false);
        this.setInitialScale(0);
        this.setBackgroundColor(0);
        ViewUtilities.setBackground((View)this, (Drawable)new ColorDrawable(0));
        this.setBackgroundResource(0);
        boolean isWebMessageEnabled = experiments.isWebMessageEnabled();
        if (isWebMessageEnabled) {
            this.getSdkMetricsSender().sendMetric(WebViewMetricKt.webMessageListenerEnabledMetric());
        } else {
            this.getSdkMetricsSender().sendMetric(WebViewMetricKt.webMessageListenerDisabledMetric());
        }
        boolean isWebMessageListenerSupported = WebViewFeature.isFeatureSupported((String)"WEB_MESSAGE_LISTENER");
        if (isWebMessageListenerSupported) {
            this.getSdkMetricsSender().sendMetric(WebViewMetricKt.webMessageListenerSupportedMetric());
        } else {
            this.getSdkMetricsSender().sendMetric(WebViewMetricKt.webMessageListenerUnsupportedMetric());
        }
        if (isWebMessageEnabled && isWebMessageListenerSupported) {
            WebViewCompat.addWebMessageListener((android.webkit.WebView)this, (String)"handleInvocation", (Set)SetsKt.setOf((Object)"*"), this.webViewBridgeInterface::onHandleInvocation);
            WebViewCompat.addWebMessageListener((android.webkit.WebView)this, (String)"handleCallback", (Set)SetsKt.setOf((Object)"*"), this.webViewBridgeInterface::onHandleCallback);
        } else {
            this.addJavascriptInterface(this.webViewBridgeInterface, "webviewbridge");
        }
        this.applySafeAreaInsets();
    }

    public /* synthetic */ WebView(Context context, boolean bl, IWebViewBridge iWebViewBridge, IInvocationCallbackInvoker iInvocationCallbackInvoker, IExperiments iExperiments, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            iWebViewBridge = SharedInstances.INSTANCE.getWebViewBridge();
        }
        if ((n & 8) != 0) {
            iInvocationCallbackInvoker = SharedInstances.INSTANCE.getWebViewAppInvocationCallbackInvoker();
        }
        if ((n & 0x10) != 0) {
            iExperiments = new Experiments();
        }
        this(context, bl, iWebViewBridge, iInvocationCallbackInvoker, iExperiments);
    }

    private final SDKMetricsSender getSdkMetricsSender() {
        Lazy lazy = this.sdkMetricsSender$delegate;
        return (SDKMetricsSender)lazy.getValue();
    }

    public void evaluateJavascript(@NotNull String script, @Nullable ValueCallback<String> resultCallback) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        Utilities.runOnUiThread(() -> WebView.evaluateJavascript$lambda$1(this, script, resultCallback));
    }

    public void loadUrl(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        DeviceLog.debug("Loading url: " + url);
        super.loadUrl(url);
    }

    private final void applySafeAreaInsets() {
        ViewCompat.setOnApplyWindowInsetsListener((View)((View)this), (arg_0, arg_1) -> WebView.applySafeAreaInsets$lambda$3(this, arg_0, arg_1));
    }

    @Override
    @NotNull
    public IServiceProvider getServiceProvider() {
        return IServiceComponent.DefaultImpls.getServiceProvider(this);
    }

    @JvmOverloads
    public WebView(@NotNull Context context, boolean shouldNotRequireGesturePlayback, @NotNull IWebViewBridge webViewBridge2, @NotNull IInvocationCallbackInvoker callbackInvoker) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)webViewBridge2, (String)"webViewBridge");
        Intrinsics.checkNotNullParameter((Object)callbackInvoker, (String)"callbackInvoker");
        this(context, shouldNotRequireGesturePlayback, webViewBridge2, callbackInvoker, null, 16, null);
    }

    @JvmOverloads
    public WebView(@NotNull Context context, boolean shouldNotRequireGesturePlayback, @NotNull IWebViewBridge webViewBridge2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)webViewBridge2, (String)"webViewBridge");
        this(context, shouldNotRequireGesturePlayback, webViewBridge2, null, null, 24, null);
    }

    @JvmOverloads
    public WebView(@NotNull Context context, boolean shouldNotRequireGesturePlayback) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, shouldNotRequireGesturePlayback, null, null, null, 28, null);
    }

    @JvmOverloads
    public WebView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, false, null, null, null, 30, null);
    }

    private static final void evaluateJavascript$lambda$1(WebView this$0, String $script, ValueCallback $resultCallback) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$script, (String)"$script");
        super.evaluateJavascript($script, $resultCallback);
    }

    private static final int applySafeAreaInsets$lambda$3$toPx(int $this$applySafeAreaInsets_u24lambda_u243_u24toPx, float density) {
        return (int)((float)$this$applySafeAreaInsets_u24lambda_u243_u24toPx / density);
    }

    private static final WindowInsetsCompat applySafeAreaInsets$lambda$3(WebView this$0, View v, WindowInsetsCompat insets) {
        Object $this$applySafeAreaInsets_u24lambda_u243_u24lambda_u242;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        Intrinsics.checkNotNullParameter((Object)insets, (String)"insets");
        Insets insets2 = insets.getInsets(WindowInsetsCompat.Type.systemBars());
        Intrinsics.checkNotNullExpressionValue((Object)insets2, (String)"insets.getInsets(WindowI\u2026Compat.Type.systemBars())");
        Insets systemBarsInsets = insets2;
        Insets insets3 = insets.getInsets(WindowInsetsCompat.Type.displayCutout());
        Intrinsics.checkNotNullExpressionValue((Object)insets3, (String)"insets.getInsets(WindowI\u2026pat.Type.displayCutout())");
        Insets displayCutout = insets3;
        Object object = this$0;
        try {
            $this$applySafeAreaInsets_u24lambda_u243_u24lambda_u242 = object;
            boolean bl = false;
            $this$applySafeAreaInsets_u24lambda_u243_u24lambda_u242 = Result.constructor-impl((Object)Float.valueOf($this$applySafeAreaInsets_u24lambda_u243_u24lambda_u242.getContext().getResources().getDisplayMetrics().density));
        }
        catch (Throwable bl) {
            $this$applySafeAreaInsets_u24lambda_u243_u24lambda_u242 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$applySafeAreaInsets_u24lambda_u243_u24lambda_u242;
        $this$applySafeAreaInsets_u24lambda_u243_u24lambda_u242 = Float.valueOf(1.0f);
        float density = ((Number)(Result.isFailure-impl((Object)object) ? $this$applySafeAreaInsets_u24lambda_u243_u24lambda_u242 : object)).floatValue();
        int left = WebView.applySafeAreaInsets$lambda$3$toPx(Math.max(systemBarsInsets.left, displayCutout.left), density);
        int top = WebView.applySafeAreaInsets$lambda$3$toPx(Math.max(systemBarsInsets.top, displayCutout.top), density);
        int right = WebView.applySafeAreaInsets$lambda$3$toPx(Math.max(systemBarsInsets.right, displayCutout.right), density);
        int bottom = WebView.applySafeAreaInsets$lambda$3$toPx(Math.max(systemBarsInsets.bottom, displayCutout.bottom), density);
        String js = StringsKt.trimIndent((String)("\n                (function() {\n                    const root = document.documentElement;\n                    root.style.setProperty('--safe-area-inset-left', '" + left + "px');\n                    root.style.setProperty('--safe-area-inset-right', '" + right + "px');\n                    root.style.setProperty('--safe-area-inset-top', '" + top + "px');\n                    root.style.setProperty('--safe-area-inset-bottom', '" + bottom + "px');\n                })();\n            "));
        this$0.evaluateJavascript(js, null);
        return insets;
    }
}

