/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.configuration;

import com.unity3d.services.core.configuration.PrivacyConfigStatus;
import org.json.JSONObject;

public class PrivacyConfig {
    private PrivacyConfigStatus _privacyConfigStatus;
    private boolean _shouldSendNonBehavioral;

    public PrivacyConfig() {
        this(PrivacyConfigStatus.UNKNOWN);
    }

    public PrivacyConfig(JSONObject privacyResponse) {
        this.parsePrivacyResponse(privacyResponse);
    }

    public PrivacyConfig(PrivacyConfigStatus privacyConfigStatus) {
        this._privacyConfigStatus = privacyConfigStatus;
        this._shouldSendNonBehavioral = false;
    }

    public boolean allowedToSendPii() {
        return this._privacyConfigStatus.equals((Object)PrivacyConfigStatus.ALLOWED);
    }

    public boolean shouldSendNonBehavioral() {
        return this._shouldSendNonBehavioral;
    }

    public PrivacyConfigStatus getPrivacyStatus() {
        return this._privacyConfigStatus;
    }

    private void parsePrivacyResponse(JSONObject privacyResponse) {
        this._privacyConfigStatus = privacyResponse.optBoolean("pas", false) ? PrivacyConfigStatus.ALLOWED : PrivacyConfigStatus.DENIED;
        this._shouldSendNonBehavioral = privacyResponse.optBoolean("snb", false);
    }
}

