package com.unity3d.ads.core.domain.events

import com.google.protobuf.ByteString
import com.unity3d.ads.core.data.model.AdObject
import com.unity3d.ads.core.data.repository.OperativeEventRepository
import gatewayprotocol.v1.DiagnosticEventRequestOuterClass.DiagnosticAdType
import gatewayprotocol.v1.InitializationResponseOuterClass.AdFormat
import gatewayprotocol.v1.OperativeEventRequestOuterClass.OperativeEventType

internal class GetOperativeEventApi(
    private val operativeEventRepository: OperativeEventRepository,
    private val operativeEventRequest: GetOperativeEventRequest,
) {
    suspend operator fun invoke(
        operativeEventType: OperativeEventType,
        opportunityId: ByteString,
        trackingToken: ByteString,
        additionalEventData: ByteString,
        playerServerId: String? = null,
        adFormat: AdFormat? = null) {
        val operativeEvent = operativeEventRequest(
            operativeEventType = operativeEventType,
            opportunityId = opportunityId,
            additionalEventData = additionalEventData,
            loadTrackingToken = trackingToken,
            playerServerId = playerServerId,
            adFormat = adFormat
        )
        // Adds the event to the operative event flow
        operativeEventRepository.addOperativeEvent(operativeEvent)
    }

    suspend operator fun invoke(
        operativeEventType: OperativeEventType,
        adObject: AdObject,
        additionalEventData: ByteString
    ) {
        invoke(
            operativeEventType = operativeEventType,
            opportunityId = adObject.opportunityId,
            trackingToken = adObject.trackingToken,
            additionalEventData = additionalEventData,
            playerServerId = adObject.playerServerId,
            adFormat = takeIf { adObject.adType == DiagnosticAdType.DIAGNOSTIC_AD_TYPE_BANNER }
                ?.let { AdFormat.AD_FORMAT_BANNER }
        )
    }
}