package com.unity3d.ads.core.domain

import com.unity3d.ads.core.data.repository.CacheRepository
import com.unity3d.ads.core.domain.SendDiagnosticEvent.Companion.SIZE_KB
import com.unity3d.ads.core.extensions.elapsedMillis

import kotlin.time.ExperimentalTime
import kotlin.time.TimeSource


@OptIn(ExperimentalTime::class)
class CommonCleanAssets(
    private val cacheRepository: CacheRepository,
    private val sendDiagnosticEvent: SendDiagnosticEvent
) : CleanAssets {
    override suspend fun invoke() {
        val startTime = TimeSource.Monotonic.markNow()
        val currentSize = cacheRepository.getCacheSize()
        cacheRepository.clearCache()
        sendDiagnosticEvent.invoke(
            event = SendDiagnosticEvent.INIT_CLEAN_ASSETS,
            value = startTime.elapsedMillis(),
            intTags = mapOf(
                SIZE_KB to (currentSize / 1024).toInt()
            )
        )
    }
}