package com.unity3d.ads.adplayer.model

import com.unity3d.scar.adapter.common.GMAEvent
import com.unity3d.services.ads.offerwall.OfferwallEvent
import com.unity3d.services.banners.bridge.BannerBridge.BannerEvent
import com.unity3d.services.core.device.StorageEvent
import com.unity3d.services.core.device.StorageManager

sealed interface WebViewEvent {
    val category: String
    val name: String
    val parameters: Array<Any?>
}

class OnVisibilityChangeEvent(isVisible: Boolean) : WebViewEvent {
    override val category = "ADVIEWER"
    override val name = "ON_VISIBILITY_CHANGE"
    override val parameters = arrayOf<Any?>(isVisible)
}

class OnFocusChangeEvent(isFocused: Boolean) : WebViewEvent {
    override val category = "ADVIEWER"
    override val name = "ON_FOCUS_CHANGE"
    override val parameters = arrayOf<Any?>(isFocused)
}

class OnActivityDestroyedEvent : WebViewEvent {
    override val category = "ADVIEWER"
    override val name = "ON_ACTIVITY_DESTROY"
    override val parameters = emptyArray<Any?>()
}

class OnMuteChangeEvent(
    isMuted: Boolean,
) : WebViewEvent {
    override val category = "ADVIEWER"
    override val name = "ON_MUTE_CHANGE"
    override val parameters = arrayOf<Any?>(isMuted)
}

class OnScarBannerEvent(
    bannerEvent: BannerEvent,
) : WebViewEvent {
    override val category = "BANNER"
    override val name = bannerEvent.name
    override val parameters = emptyArray<Any?>()
}

class OnGmaEvent(gmaEvent: GMAEvent) : WebViewEvent {
    override val category = "GMA"
    override val name = gmaEvent.name
    override val parameters = emptyArray<Any?>()
}

class OnOfferwallEvent(offerwallEvent: OfferwallEvent) : WebViewEvent {
    override val category = "OFFERWALL"
    override val name = offerwallEvent.name
    override val parameters = emptyArray<Any?>()
}

class OnStorageEvent(
    eventType: StorageEvent,
    storageType: StorageManager.StorageType,
    value: Any?,
) : WebViewEvent {
    override val category = "STORAGE"
    override val name = eventType.name
    override val parameters = arrayOf(storageType.name, value)
}

class OnVolumeChangeEvent(
    volume: Double,
) : WebViewEvent {
    override val category = "ADVIEWER"
    override val name = "ON_VOLUME_CHANGE"
    override val parameters = arrayOf<Any?>(volume)
}

class OnUserConsentChangeEvent(
    value: String,
) : WebViewEvent {
    override val category = "ADVIEWER"
    override val name = "ON_USER_CONSENT_CHANGE"
    override val parameters = arrayOf<Any?>(value)
}

class OnPrivacyFsmChangeEvent(
    value: String,
) : WebViewEvent {
    override val category = "ADVIEWER"
    override val name = "ON_PRIVACY_FSM_CHANGE"
    override val parameters = arrayOf<Any?>(value)
}

class OnBroadcastEvent(
    override val name: String,
    value: String?,
) : WebViewEvent {
    override val category = "ADVIEWER"
    override val parameters = arrayOf<Any?>(value)
}

class OnAllowedPiiChangeEvent(
    value: String,
) : WebViewEvent {
    override val category = "ADVIEWER"
    override val name = "ON_ALLOWED_PII_CHANGE"
    override val parameters = arrayOf<Any?>(value)
}

class OnWebRequestComplete(
    value: List<Any?>,
) : WebViewEvent {
    override val category = "REQUEST"
    override val name = "COMPLETE"
    override val parameters = value.toTypedArray()
}

class OnWebRequestFailed(
    value: List<Any?>,
) : WebViewEvent {
    override val category = "REQUEST"
    override val name = "FAILED"
    override val parameters = value.toTypedArray()
}
