/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.ads.core.data.repository;

import com.google.protobuf.ByteString;
import com.unity3d.ads.core.data.model.AdObject;
import com.unity3d.ads.core.data.repository.AdRepository;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0006H\u0016J\u0018\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0005H\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00062\u0006\u0010\f\u001a\u00020\u0005H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\u0005H\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000f\u001a\u00020\bH\u0016J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\t0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/unity3d/ads/core/data/repository/AndroidAdRepository;", "Lcom/unity3d/ads/core/data/repository/AdRepository;", "()V", "loadedAds", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/google/protobuf/ByteString;", "Lcom/unity3d/ads/core/data/model/AdObject;", "placementsLoadedAds", "", "", "addAd", "", "opportunityId", "adObject", "enqueueOpportunityForPlacement", "placementId", "getAd", "hasOpportunityId", "", "pollOpportunityIdForPlacement", "removeAd", "unity-ads_release"})
@SourceDebugExtension(value={"SMAP\nAndroidAdRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidAdRepository.kt\ncom/unity3d/ads/core/data/repository/AndroidAdRepository\n+ 2 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,35:1\n73#2,2:36\n1#3:38\n*S KotlinDebug\n*F\n+ 1 AndroidAdRepository.kt\ncom/unity3d/ads/core/data/repository/AndroidAdRepository\n*L\n24#1:36,2\n24#1:38\n*E\n"})
public final class AndroidAdRepository
implements AdRepository {
    @NotNull
    private final ConcurrentHashMap<ByteString, AdObject> loadedAds = new ConcurrentHashMap();
    @NotNull
    private final ConcurrentHashMap<String, List<ByteString>> placementsLoadedAds = new ConcurrentHashMap();

    @Override
    public void addAd(@NotNull ByteString opportunityId, @NotNull AdObject adObject2) {
        Intrinsics.checkNotNullParameter((Object)opportunityId, (String)"opportunityId");
        Intrinsics.checkNotNullParameter((Object)adObject2, (String)"adObject");
        ((Map)this.loadedAds).put(opportunityId, adObject2);
    }

    @Override
    @Nullable
    public AdObject getAd(@NotNull ByteString opportunityId) {
        Intrinsics.checkNotNullParameter((Object)opportunityId, (String)"opportunityId");
        return this.loadedAds.get(opportunityId);
    }

    @Override
    @Nullable
    public ByteString pollOpportunityIdForPlacement(@NotNull String placementId) {
        Intrinsics.checkNotNullParameter((Object)placementId, (String)"placementId");
        List<ByteString> list = this.placementsLoadedAds.get(placementId);
        return list != null ? (ByteString)CollectionsKt.removeFirstOrNull(list) : null;
    }

    @Override
    public void enqueueOpportunityForPlacement(@NotNull String placementId, @NotNull ByteString opportunityId) {
        Intrinsics.checkNotNullParameter((Object)placementId, (String)"placementId");
        Intrinsics.checkNotNullParameter((Object)opportunityId, (String)"opportunityId");
        ConcurrentMap $this$getOrPut$iv = this.placementsLoadedAds;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(placementId);
        if (object == null) {
            boolean bl = false;
            List default$iv = new ArrayList();
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(placementId, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        ((List)object).add(opportunityId);
    }

    @Override
    public void removeAd(@NotNull ByteString opportunityId) {
        Intrinsics.checkNotNullParameter((Object)opportunityId, (String)"opportunityId");
        this.loadedAds.remove(opportunityId);
    }

    @Override
    public boolean hasOpportunityId(@NotNull ByteString opportunityId) {
        Intrinsics.checkNotNullParameter((Object)opportunityId, (String)"opportunityId");
        return this.loadedAds.containsKey(opportunityId);
    }
}

