package com.unity3d.ads.network.mapper

import com.unity3d.ads.network.model.HttpBody
import com.unity3d.ads.network.model.HttpRequest
import okhttp3.Headers
import okhttp3.MediaType
import okhttp3.Request
import okhttp3.RequestBody

private fun generateOkHttpBody(body: HttpBody): RequestBody? = when(body) {
    is HttpBody.StringBody -> RequestBody.create(MediaType.parse("text/plain;charset=utf-8"), body.content)
    is HttpBody.ByteArrayBody -> RequestBody.create(MediaType.parse("text/plain;charset=utf-8"), body.content)
    is HttpBody.EmptyBody -> null
}

private fun HttpRequest.generateOkHttpHeaders(): Headers = Headers.Builder()
    .also { headers.forEach { (key, value) -> it.add(key, value.joinToString(",")) } }
    .build()

fun HttpRequest.toOkHttpRequest(): Request = Request.Builder()
    .url("${baseURL.trim('/')}/${path.trim('/')}".removeSuffix("/"))
    .method(method.toString(), generateOkHttpBody(body))
    .headers(generateOkHttpHeaders())
    .build()
