package com.unity3d.ads.core.domain

import com.unity3d.ads.core.data.model.AdObject


interface SendDiagnosticEvent {
    operator fun invoke(event: String, value: Double? = null, tags: Map<String, String>? = null, intTags: Map<String, Int>? = null, adObject: AdObject? = null)

    companion object {
        // initialize
        const val INIT_STARTED = "native_initialization_started"
        const val INIT_SUCCESS = "native_initialize_task_success_time"
        const val INIT_FAILURE = "native_initialize_task_failure_time"
        const val INIT_CLEAN_ASSETS = "native_clean_assets_task_success_time"
        const val INIT_MISSED_NATIVE_PARSING = "native_initialize_missed_native_parsing"
        const val INIT_GAME_ID_CHANGED = "native_initialize_game_id_changed"
        const val INIT_GAME_ID_SAME = "native_initialize_game_id_same"
        const val INIT_TEST_MODE_CHANGED = "native_initialize_test_mode_changed"
        const val INIT_TEST_MODE_SAME = "native_initialize_test_mode_same"
        // initialization success
        const val INIT_COMPLETED_STARTED = "native_initialization_completed_event_request_started"
        const val INIT_COMPLETED_SUCCESS = "native_initialization_completed_event_request_success_time"
        const val INIT_COMPLETED_FAILURE = "native_initialization_completed_event_request_failure_time"
        // load
        const val LOAD_STARTED = "native_load_started"
        const val LOAD_STARTED_AD_VIEWER = "native_load_started_ad_viewer"
        const val LOAD_SUCCESS = "native_load_success_time"
        const val LOAD_FAILURE = "native_load_failure_time"
        const val LOAD_CACHE_SUCCESS = "native_load_cache_success_time"
        const val LOAD_CACHE_FAILURE = "native_load_cache_failure_time"
        // show
        const val SHOW_STARTED = "native_show_started"
        const val SHOW_STARTED_AD_VIEWER = "native_show_started_ad_viewer"
        const val SHOW_AD_VIEWER_FULLSCREEN = "native_show_ad_viewer_fullscreen"
        const val SHOW_AD_VIEWER_FULLSCREEN_INTENT = "native_show_ad_viewer_fullscreen_intent"
        const val SHOW_AD_VIEWER_FULLSCREEN_ACTIVITY_EVENT = "native_show_ad_viewer_fullscreen_activity_event"
        const val SHOW_EVENT_FLOW_STARTED = "native_show_event_flow_started"
        const val SHOW_EVENT_FLOW_COLLECTED = "native_show_event_flow_collected"
        const val SHOW_EVENT_FLOW_COMPLETED = "native_show_event_flow_completed"
        const val SHOW_CANCEL_TIMEOUT = "native_show_cancel_timeout"
        const val SHOW_WV_STARTED = "native_show_wv_started"
        const val SHOW_SUCCESS = "native_show_success_time"
        const val SHOW_FAILURE = "native_show_failure_time"
        const val SHOW_CLICKED = "native_show_clicked"
        const val SHOW_LEFT_APPLICATION = "native_show_left_app"
        const val SHOW_IS_FILE_CACHED_SUCCESS = "native_show_is_file_cached_success_time"
        const val SHOW_IS_FILE_CACHED_FAILURE = "native_show_is_file_cached_failure_time"
        const val SHOW_AD_VIEWER_FULLSCREEN_INTENT_CREATION_STARTS = "native_show_ad_viewer_fullscreen_intent_creation_starts"
        const val SHOW_AD_VIEWER_FULLSCREEN_INTENT_CREATION_FAILS = "native_show_ad_viewer_fullscreen_intent_creation_fails"
        const val SHOW_AD_VIEWER_FULLSCREEN_INTENT_CREATION_SUCCESS = "native_show_ad_viewer_fullscreen_intent_creation_success_time"
        const val SHOW_AD_VIEWER_FULLSCREEN_INTENT_DESTROYED = "native_show_ad_viewer_fullscreen_intent_destroyed"
        // banner only
        const val BANNER_DESTROYED = "native_banner_destroyed"
        // header bidding
        const val HB_STARTED = "native_gateway_token_started"
        const val HB_SUCCESS = "native_gateway_token_success_time"
        const val HB_FAILURE = "native_gateway_token_failure_time"
        // network
        const val NETWORK_SUCCESS = "native_network_success_time"
        const val NETWORK_FAILURE = "native_network_failure_time"
        const val NETWORK_PARSE = "native_network_parse_failure"
        // webview
        const val WEBVIEW_ERROR = "webview_error"
        // system
        const val SYSTEM_CRONET_SUCCESS = "native_cronet_success_time"
        const val SYSTEM_CRONET_FAILURE = "native_cronet_failure_time"
        // tags
        const val REASON = "reason"
        const val REASON_DEBUG = "reason_debug"
        const val REASON_CODE = "reason_code"
        const val COROUTINE_NAME = "coroutine_name"
        const val WEBVIEW_URL = "webview_url"
        const val WEBVIEW_ERROR_CODE = "webview_error_code"
        const val OPERATION = "operation"
        const val RETRIES = "retries"
        const val PROTOCOL = "protocol"
        const val NETWORK_CLIENT = "network_client"
        const val SYNC = "sync"
        const val STATE = "state"
        const val COMPLETE_STATE = "complete_state"
        const val SAME_SESSION = "same_session"
        const val APP_ACTIVE = "app_active"
        const val SHOW_HAS_STARTED = "show_has_started"
        const val CACHE_SOURCE = "cache_source"
        const val SIZE_KB = "size_kb"
        const val URL = "url"
        const val AWAITED_INIT = "awaited_init"
        const val GAME_ID = "game_id"
        const val PREVIOUS_GAME_ID = "previous_game_id"
        const val TEST_MODE = "test_mode"
        const val PREVIOUS_TEST_MODE = "previous_test_mode"
        const val IS_RETRY = "is_retry"
        // AdViewer
        const val BRIDGE_SEND_EVENT_FAILED = "bridge_send_event_failed"
        // Open Measurement
        const val OM_ACTIVATE_STARTED = "om_activate_started"
        const val OM_ACTIVATE_FAILURE = "om_activate_failure_time"
        const val OM_ACTIVATE_SUCCESS = "om_activate_success_time"
        const val OM_SESSION_START_SUCCESS = "om_session_start_success"
        const val OM_SESSION_START_FAILURE = "om_session_start_failure"
        const val OM_SESSION_FINISH_SUCCESS = "om_session_finish_success"
        const val OM_SESSION_FINISH_FAILURE = "om_session_finish_failure"
        const val OM_IMPRESSION_OCCURRED_SUCCESS = "om_impression_occurred_success"
        const val OM_IMPRESSION_OCCURRED_FAILURE = "om_impression_occurred_failure"
        //Source
        const val SOURCE = "source"
        const val SOURCE_PUBLIC_API = "api"
        const val SOURCE_LOAD_API = "load"
        const val SOURCE_GET_TOKEN_API = "get_token"
        // Billing Service
        const val BILLING_SERVICE_UNAVAILABLE = "billing_service_unavailable"
        // SCAR
        const val SCAR_SIGNALS_COLLECTION_STARTED = "native_scar_signals_collection_started"
        const val SCAR_SIGNALS_COLLECTION_SUCCESS = "native_scar_signals_collection_success_time"
        const val SCAR_SIGNALS_COLLECTION_FAILURE = "native_scar_signals_collection_failure_time"
        const val SCAR_SIGNALS_UPLOAD_STARTED = "native_scar_signals_upload_started"
        const val SCAR_SIGNALS_UPLOAD_SUCCESS = "native_scar_signals_upload_success_time"
        const val SCAR_SIGNALS_UPLOAD_FAILURE = "native_scar_signals_upload_failure_time"
        const val SCAR_VIDEO_LENGTH_IN_SEC = "native_scar_video_length_in_sec"
        // Reason
        const val REASON_UNKNOWN = "unknown"
        const val REASON_TIMEOUT = "timeout"
        const val REASON_TIMEOUT_INITIALIZATION = "timeout_initialization"
        const val REASON_NO_FILL = "no_fill"
        const val REASON_NETWORK = "network"
        const val REASON_GATEWAY = "gateway"
        const val REASON_INVALID_GAME_ID = "invalid_game_id"
        const val REASON_ALREADY_SHOWING = "already_showing"
        const val REASON_NOT_INITIALIZED = "not_initialized"
        const val REASON_PLACEMENT_NULL = "placement_null"
        const val REASON_PLACEMENT_NOT_LOADED = "placement_not_loaded"
        const val REASON_OPPORTUNITY_ID = "no_opportunity_id"
        const val REASON_OPPORTUNITY_USED = "opportunity_id_used"
        const val REASON_AD_MARKUP_PARSE = "invalid_admarkup"
        const val REASON_UNCAUGHT_EXCEPTION = "uncaught_exception"
        const val REASON_NO_WEBVIEW_ENTRY_POINT = "no_webview_entry_point"
        const val REASON_INVALID_ENTRY_POINT = "invalid_url"
        const val REASON_AD_VIEWER = "adviewer"
        const val REASON_AD_OBJECT_NOT_FOUND = "ad_object_not_found"
        const val REASON_AD_PLAYER_SCOPE = "ad_player_scope_not_active"
        const val REASON_PLACEMENT_VALIDATION = "placement_validation"
        const val REASON_OM_NOT_ACTIVE = "om_not_active"
        const val REASON_OM_ALREADY_ACTIVE = "om_already_active"
        const val REASON_OM_SESSION_NOT_FOUND = "om_session_not_found"
        const val REASON_OM_SESSION_ALREADY_EXISTS = "om_session_already_exists"
        const val REASON_OM_CREATIVE_TYPE_NULL = "om_creative_type_null"
        const val REASON_OM_CREATIVE_TYPE_INVALID = "om_creative_type_invalid"
        const val REASON_LISTENER_NULL = "listener_null"
        const val REASON_PROTOBUF_PARSING = "protobuf_parsing"
        // Custom
        const val ATTEMPT_INSERT_NULL_DIAGNOSTIC_EVENT = "attempt_insert_null_diagnostic_event"
        const val NULL_DIAGNOSTIC_EVENT = "null_diagnostic_event"
        const val OLD_CALLBACK_STATUS = "old_callback_status"
    }
}