package com.unity3d.ads.core.domain

import com.unity3d.ads.core.data.repository.SessionRepository
import com.unity3d.ads.core.domain.scar.FetchSignalsAndSendUseCase
import com.unity3d.ads.core.extensions.toBase64

internal class CommonGetHeaderBiddingToken(
    private val buildHeaderBiddingToken: BuildHeaderBiddingToken,
    private val fetchSignalsAndSendUseCase: FetchSignalsAndSendUseCase,
    private val sessionRepository: SessionRepository
) : GetHeaderBiddingToken {
    override suspend fun invoke(): String {
        val rawToken = buildHeaderBiddingToken(sessionRepository.scarEligibleFormats.isNotEmpty())
        // collect and send scar signals
        if (sessionRepository.scarEligibleFormats.isNotEmpty()) {
            fetchSignalsAndSendUseCase(rawToken.tokenId)
        }
        // mediation receives a base64 encoded string
        val token = rawToken.toByteString().toBase64()
        // append version
        return "$HB_TOKEN_VERSION:$token"
    }

    companion object {
        const val HB_TOKEN_VERSION = "2"
    }
}