package com.unity3d.ads.core.data.repository

import com.google.protobuf.ByteString
import com.unity3d.ads.core.data.model.AdObject
import java.util.concurrent.ConcurrentHashMap

class AndroidAdRepository : AdRepository {
    private val loadedAds = ConcurrentHashMap<ByteString, AdObject>()
    private val placementsLoadedAds = ConcurrentHashMap<String, MutableList<ByteString>>()

    override fun addAd(opportunityId: ByteString, adObject: AdObject) {
        loadedAds[opportunityId] = adObject
    }

    override fun getAd(opportunityId: ByteString) : AdObject? {
        return loadedAds[opportunityId]
    }

    override fun pollOpportunityIdForPlacement(placementId: String): ByteString? {
        return placementsLoadedAds[placementId]?.removeFirstOrNull()
    }

    override fun enqueueOpportunityForPlacement(placementId: String, opportunityId: ByteString) {
        placementsLoadedAds.getOrPut(placementId) { mutableListOf() }
            .add(opportunityId)
    }

    override fun removeAd(opportunityId: ByteString) {
        loadedAds.remove(opportunityId)
    }

    override fun hasOpportunityId(opportunityId: ByteString): Boolean {
        return loadedAds.containsKey(opportunityId)
    }
}