package com.unity3d.ads.core.domain.om

import com.unity3d.ads.core.data.model.AdObject
import com.unity3d.ads.core.data.model.OMResult
import com.unity3d.ads.core.data.repository.OpenMeasurementRepository
import com.unity3d.ads.core.domain.SendDiagnosticEvent



class AndroidOmImpressionOccurred(
    private val openMeasurementRepository: OpenMeasurementRepository,
    private val sendDiagnosticEvent: SendDiagnosticEvent
): OmImpressionOccurred {
    override suspend fun invoke(adObject: AdObject, signalLoaded: Boolean) {
        when (val result = openMeasurementRepository.impressionOccurred(
            adObject.opportunityId,
            signalLoaded
        )) {
            is OMResult.Success -> sendDiagnosticEvent(SendDiagnosticEvent.OM_IMPRESSION_OCCURRED_SUCCESS, adObject = adObject)
            is OMResult.Failure -> sendDiagnosticEvent(
                SendDiagnosticEvent.OM_IMPRESSION_OCCURRED_FAILURE,
                tags = buildMap {
                    put(SendDiagnosticEvent.REASON, result.reason)
                    result.reasonDebug?.let {
                        put(SendDiagnosticEvent.REASON_DEBUG, result.reasonDebug)
                    }
                },
                adObject = adObject
            )
        }
    }
}