package com.unity3d.ads.core.data.repository

import com.unity3d.ads.core.data.model.CacheResult
import com.unity3d.ads.core.data.model.CachedFile
import org.json.JSONArray

interface CacheRepository {
    suspend fun getFile(url: String, objectId: String, headers: JSONArray? = null, priority: Int = 0): CacheResult
    fun removeFile(cachedFile: CachedFile): Boolean
    suspend fun doesFileExist(fileName: String): Boolean
    fun retrieveFile(fileName: String): CacheResult
    suspend fun clearCache()
    suspend fun getCacheSize(): Long
}