package com.unity3d.ads.core.data.repository

import com.google.protobuf.ByteString
import com.unity3d.ads.core.data.model.AdObject
import java.util.concurrent.ConcurrentHashMap

class AndroidAdRepository : AdRepository {
    private val loadedAds = ConcurrentHashMap<ByteString, AdObject>()

    override suspend fun addAd(opportunityId: ByteString, adObject: AdObject) {
        loadedAds[opportunityId] = adObject
    }

    override suspend fun getAd(opportunityId: ByteString) : AdObject? {
        return loadedAds[opportunityId]
    }

    override suspend fun removeAd(opportunityId: ByteString) {
        loadedAds.remove(opportunityId)
    }

    override suspend fun hasOpportunityId(opportunityId: ByteString): Boolean {
        return loadedAds.containsKey(opportunityId)
    }
}