package com.unity3d.ads.core.domain.scar

import com.unity3d.ads.core.data.manager.ScarManager

class LoadScarAd(private val scarManager: ScarManager) {
    suspend operator fun invoke(
        adFormat: String,
        placementId: String,
        adUnitId: String,
        adString: String, // Also known as content
        queryId: String,
        videoLength: Int
    ) {
        // For banner, we don't need to actually do any operations
        if (adFormat == "banner") return
        scarManager.loadAd(
            adFormat = adFormat,
            placementId = placementId,
            adUnitId = adUnitId,
            adString = adString,
            queryId = queryId,
            videoLength = videoLength
        )
    }

}