package com.unity3d.ads.core.domain

import com.unity3d.ads.core.data.repository.SessionRepository
import com.unity3d.ads.gatewayclient.RequestPolicy

internal class GetOtherRequestPolicy(private val sessionRepository: SessionRepository): GetRequestPolicy {
    override fun invoke(): RequestPolicy {
        return RequestPolicy(
            maxDuration = sessionRepository.nativeConfiguration.otherPolicy.retryPolicy.maxDuration,
            retryMaxInterval = sessionRepository.nativeConfiguration.otherPolicy.retryPolicy.retryMaxInterval,
            retryWaitBase = sessionRepository.nativeConfiguration.otherPolicy.retryPolicy.retryWaitBase,
            retryJitterPct = sessionRepository.nativeConfiguration.otherPolicy.retryPolicy.retryJitterPct,
            retryScalingFactor = sessionRepository.nativeConfiguration.otherPolicy.retryPolicy.retryScalingFactor,
            connectTimeout = sessionRepository.nativeConfiguration.otherPolicy.timeoutPolicy.connectTimeoutMs,
            readTimeout = sessionRepository.nativeConfiguration.otherPolicy.timeoutPolicy.readTimeoutMs,
            writeTimeout = sessionRepository.nativeConfiguration.otherPolicy.timeoutPolicy.writeTimeoutMs,
            overallTimeout = sessionRepository.nativeConfiguration.otherPolicy.timeoutPolicy.overallTimeoutMs,
            shouldStoreLocally = sessionRepository.nativeConfiguration.otherPolicy.retryPolicy.shouldStoreLocally
        )
    }
}