package com.unity3d.ads.core.domain

import com.unity3d.ads.core.data.manager.TransactionEventManager
import com.unity3d.ads.core.data.model.exception.GatewayException
import com.unity3d.ads.core.data.repository.SessionRepository
import com.unity3d.ads.core.domain.SendDiagnosticEvent.Companion.REASON_GATEWAY
import gatewayprotocol.v1.InitializationResponseOuterClass.InitializationResponse
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.launch

internal class AndroidHandleGatewayInitializationResponse(
    private val transactionEventManager: TransactionEventManager,
    private val triggerInitializationCompletedRequest: TriggerInitializationCompletedRequest,
    private val sessionRepository: SessionRepository,
    private val sdkScope: CoroutineScope
) : HandleGatewayInitializationResponse {
    override suspend fun invoke(response: InitializationResponse) {
        if (response.hasError()) (
            throw GatewayException(
                message = response.error.errorText,
                throwable = IllegalStateException(response.error.errorText),
                reason = "${REASON_GATEWAY}_${GatewayException.GATEWAY_RESPONSE_DEPTH_INITIALIZATION}",
                reasonDebug = response.error.errorText,
            )
        )

        sessionRepository.nativeConfiguration = response.nativeConfiguration
        if (response.hasUniversalRequestUrl() && !response.universalRequestUrl.isNullOrEmpty()) {
            sessionRepository.gatewayUrl = response.universalRequestUrl
        }

        sessionRepository.scarEligibleFormats.addAll(response.scarEligibleFormatsList)

        if (response.triggerInitializationCompletedRequest) {
            sdkScope.launch {
                triggerInitializationCompletedRequest()
            }
        }

        if (response.nativeConfiguration.enableIapEvent) {
            transactionEventManager()
        }

    }
}