package com.unity3d.ads.core.data.model

import com.unity3d.services.core.properties.SdkProperties
import java.util.Locale

enum class InitializationState {
    NOT_INITIALIZED,
    INITIALIZING,
    INITIALIZED,
    FAILED;

    override fun toString(): String {
        return super.toString().lowercase(Locale.getDefault())
    }
}

fun InitializationState.toLegacy(): SdkProperties.InitializationState {
    return when (this) {
        InitializationState.NOT_INITIALIZED -> SdkProperties.InitializationState.NOT_INITIALIZED
        InitializationState.INITIALIZING -> SdkProperties.InitializationState.INITIALIZING
        InitializationState.INITIALIZED -> SdkProperties.InitializationState.INITIALIZED_SUCCESSFULLY
        InitializationState.FAILED -> SdkProperties.InitializationState.INITIALIZED_FAILED
    }
}

fun SdkProperties.InitializationState.toBold(): InitializationState {
    return when (this) {
        SdkProperties.InitializationState.NOT_INITIALIZED -> InitializationState.NOT_INITIALIZED
        SdkProperties.InitializationState.INITIALIZING -> InitializationState.INITIALIZING
        SdkProperties.InitializationState.INITIALIZED_SUCCESSFULLY -> InitializationState.INITIALIZED
        SdkProperties.InitializationState.INITIALIZED_FAILED -> InitializationState.FAILED
    }
}