package com.unity3d.services.store.core

import android.app.Activity
import android.app.Application
import android.os.Bundle
import com.unity3d.services.core.log.DeviceLog
import com.unity3d.services.store.gpbl.StoreBilling
import com.unity3d.services.store.gpbl.listeners.StoreEventListener

class StoreLifecycleListener(
    private val _purchaseTypes: ArrayList<String>,
    private val _storeBilling: StoreBilling,
    private val _storeEventListener: StoreEventListener
) : Application.ActivityLifecycleCallbacks {

    override fun onActivityCreated(activity: Activity, savedInstanceState: Bundle?) {}
    override fun onActivityStarted(activity: Activity) {}
    override fun onActivityResumed(activity: Activity) {
        try {
            for (purchaseType in _purchaseTypes) {
                _storeBilling.getPurchases(purchaseType, _storeEventListener)
            }
        } catch (exception: ClassNotFoundException) {
            DeviceLog.warning("Couldn't fetch purchases onActivityResumed. " + exception.message)
        }
    }

    override fun onActivityPaused(activity: Activity) {}
    override fun onActivityStopped(activity: Activity) {}
    override fun onActivitySaveInstanceState(activity: Activity, outState: Bundle) {}
    override fun onActivityDestroyed(activity: Activity) {}
}