package com.unity3d.ads.core.utils

import com.unity3d.ads.core.data.model.exception.ExposureException
import com.unity3d.services.core.webview.bridge.WebViewCallback
import kotlin.coroutines.Continuation
import kotlin.coroutines.resume
import kotlin.coroutines.resumeWithException

class ContinuationFromCallback(private val continuation: Continuation<Any>) : WebViewCallback("", 0) {
    override fun invoke(vararg params: Any?) {
        continuation.resume(params)
    }

    override fun error(error: Enum<*>?, vararg params: Any?) {
        continuation.resumeWithException(ExposureException("Invocation failed with: $error", params))
    }
}