package com.unity3d.ads.core.extensions

import org.json.JSONArray

fun JSONArray.toTypedArray() = (0 until length()).map(::get).toTypedArray()

fun JSONArray.getHeadersMap(): Map<String, List<String>> {

    val mappedHeaders: MutableMap<String, MutableList<String>> = mutableMapOf()
    for (idx in 0 until this.length()) {
        val header = this[idx] as JSONArray
        var valueList = mappedHeaders[header.getString(0)]
        if (valueList == null) {
            valueList = mutableListOf()
        }
        valueList.add(header.getString(1))
        mappedHeaders[header.getString(0)] = valueList
    }
    return mappedHeaders
}