package com.unity3d.ads.core.domain

import com.google.protobuf.ByteString
import com.unity3d.ads.adplayer.AdPlayer
import com.unity3d.ads.adplayer.AndroidEmbeddableWebViewAdPlayer
import com.unity3d.ads.adplayer.AndroidFullscreenWebViewAdPlayer
import com.unity3d.ads.adplayer.AndroidWebViewContainer
import com.unity3d.ads.adplayer.WebViewAdPlayer
import com.unity3d.ads.adplayer.WebViewBridge
import com.unity3d.ads.core.data.manager.ScarManager
import com.unity3d.ads.core.data.repository.DeviceInfoRepository
import com.unity3d.ads.core.data.repository.OpenMeasurementRepository
import com.unity3d.ads.core.data.repository.SessionRepository
import com.unity3d.ads.core.extensions.toUUID
import com.unity3d.services.banners.BannerViewCache
import kotlinx.coroutines.CoroutineDispatcher
import kotlinx.coroutines.CoroutineScope

internal class CommonGetAdPlayer(
    private val deviceInfoRepository: DeviceInfoRepository,
    private val sessionRepository: SessionRepository,
    private val executeAdViewerRequest: ExecuteAdViewerRequest,
    private val sendDiagnosticEvent: SendDiagnosticEvent,
    private val defaultDispatcher: CoroutineDispatcher,
    private val adPlayerScope: CoroutineScope,
    private val openMeasurementRepository: OpenMeasurementRepository,
    private val scarManager: ScarManager
) : GetAdPlayer {

    override fun invoke(
        webviewBridge: WebViewBridge,
        webviewContainer: AndroidWebViewContainer,
        opportunityId: ByteString
    ): AdPlayer {
        val webViewAdPlayer = WebViewAdPlayer(
            webviewBridge,
            deviceInfoRepository,
            sessionRepository,
            executeAdViewerRequest,
            defaultDispatcher,
            sendDiagnosticEvent,
            webviewContainer,
            adPlayerScope,
        )

        // If we have a bannerView, it means load has been called via [BannerView.load()]
        val bannerView = BannerViewCache.getInstance().getBannerView(opportunityId.toUUID().toString())

        return if (bannerView == null)
            AndroidFullscreenWebViewAdPlayer(
                webViewAdPlayer = webViewAdPlayer,
                webViewContainer = webviewContainer,
                opportunityId = opportunityId.toStringUtf8(),
                deviceInfoRepository = deviceInfoRepository,
                sessionRepository = sessionRepository,
                openMeasurementRepository = openMeasurementRepository,
                scarManager = scarManager,
            ) else
            AndroidEmbeddableWebViewAdPlayer(
                webViewAdPlayer = webViewAdPlayer,
                webViewContainer = webviewContainer,
                opportunityId = opportunityId.toUUID().toString(),
                openMeasurementRepository = openMeasurementRepository,
                scarManager = scarManager,
            )
    }
}