package com.unity3d.ads.core.data.datasource

import android.content.Context
import androidx.datastore.core.DataMigration
import com.unity3d.ads.datastore.ByteStringStoreOuterClass.ByteStringStore

class ForcefulPreservingByteStringPreferenceMigration(
    private val context: Context,
    private val name: String,
    private val key: String,
    private val getByteStringData: GetByteStringData
) : DataMigration<ByteStringStore> {
    override suspend fun cleanUp() {
        // we need to retain for legacy flow for now so do nothing
    }

    override suspend fun shouldMigrate(currentData: ByteStringStore): Boolean {
        return true
    }

    override suspend fun migrate(currentData: ByteStringStore): ByteStringStore {
        val pref = context.getSharedPreferences(name, Context.MODE_PRIVATE)
        val data = pref.getString(key, null)
        if (!data.isNullOrEmpty()) {
            return ByteStringStore.newBuilder()
                .setData(getByteStringData(data))
                .build()
        }

        return currentData
    }

}