package com.unity3d.ads.core.configuration
import android.content.Context
import android.content.pm.PackageManager

class AndroidManifestIntPropertyReader (
    private val context: Context
) {
    fun getPropertyByName(propertyName: String): Int? {
        try {
            val applicationMetadata = context.packageManager.getApplicationInfo(context.packageName, PackageManager.GET_META_DATA).metaData
            return applicationMetadata.getInt(propertyName)
        } catch (exception: Exception) {
            return null
        }
    }
}