/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.configuration;

import com.unity3d.ads.core.domain.BoldExperimentHandler;
import com.unity3d.services.core.configuration.Configuration;
import com.unity3d.services.core.configuration.ConfigurationRequestFactory;
import com.unity3d.services.core.configuration.IConfigurationLoader;
import com.unity3d.services.core.configuration.IConfigurationLoaderListener;
import com.unity3d.services.core.configuration.InitializeEventsMetricSender;
import com.unity3d.services.core.misc.Utilities;
import com.unity3d.services.core.network.core.HttpClient;
import com.unity3d.services.core.network.mapper.WebRequestToHttpRequestKt;
import com.unity3d.services.core.network.model.HttpRequest;
import com.unity3d.services.core.network.model.HttpResponse;
import com.unity3d.services.core.request.WebRequest;
import com.unity3d.services.core.request.metrics.SDKMetricsSender;
import com.unity3d.services.core.request.metrics.TSIMetric;
import org.json.JSONObject;

public class ConfigurationLoader
implements IConfigurationLoader {
    private final BoldExperimentHandler _boldExperimentHandler = (BoldExperimentHandler)Utilities.getService(BoldExperimentHandler.class);
    private final Configuration _localConfiguration;
    private final ConfigurationRequestFactory _configurationRequestFactory;
    private final HttpClient _httpClient;
    private final SDKMetricsSender _sdkMetricsSender;

    public ConfigurationLoader(ConfigurationRequestFactory configurationRequestFactory, SDKMetricsSender sdkMetricsSender, HttpClient httpClient) {
        this._localConfiguration = configurationRequestFactory.getConfiguration();
        this._configurationRequestFactory = configurationRequestFactory;
        this._sdkMetricsSender = sdkMetricsSender;
        this._httpClient = httpClient;
    }

    @Override
    public void loadConfiguration(IConfigurationLoaderListener configurationLoaderListener) throws Exception {
        boolean is2XXResponseCode;
        WebRequest request2;
        try {
            request2 = this._configurationRequestFactory.getWebRequest();
        }
        catch (Exception ex) {
            configurationLoaderListener.onError("Could not create web request: " + ex);
            return;
        }
        HttpRequest httpRequest = WebRequestToHttpRequestKt.toHttpRequest(request2);
        InitializeEventsMetricSender.getInstance().didConfigRequestStart();
        HttpResponse response = this._httpClient.executeBlocking(httpRequest);
        String data = response.getBody().toString();
        boolean bl = is2XXResponseCode = response.getStatusCode() / 100 == 2;
        if (!is2XXResponseCode) {
            configurationLoaderListener.onError("Non 2xx HTTP status received from ads configuration request.");
            return;
        }
        try {
            this._boldExperimentHandler.invoke(data);
            this._localConfiguration.handleConfigurationData(new JSONObject(data), true);
        }
        catch (Exception e) {
            configurationLoaderListener.onError("Could not create web request");
            return;
        }
        this.sendConfigMetrics(this._localConfiguration.getUnifiedAuctionToken(), this._localConfiguration.getStateId());
        configurationLoaderListener.onSuccess(this._localConfiguration);
    }

    @Override
    public Configuration getLocalConfiguration() {
        return this._localConfiguration;
    }

    private void sendConfigMetrics(String unifiedAuctionToken, String stateId) {
        if (unifiedAuctionToken == null || unifiedAuctionToken.isEmpty()) {
            this._sdkMetricsSender.sendMetric(TSIMetric.newMissingToken());
        }
        if (stateId == null || stateId.isEmpty()) {
            this._sdkMetricsSender.sendMetric(TSIMetric.newMissingStateId());
        }
    }
}

