package com.unity3d.ads.core.domain

class CommonGetFileExtensionFromUrl(val removeUrlQuery: RemoveUrlQuery) : GetFileExtensionFromUrl {
    override fun invoke(url: String): String? {
        val urlWithoutQuery = removeUrlQuery(url) ?: return null
        val afterLastSlash = urlWithoutQuery.substringAfterLast('/')
        return if (afterLastSlash.contains('.')) {
            afterLastSlash.substringAfterLast('.').ifEmpty { null }
        } else {
            null
        }
    }
}