/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.device.reader;

import com.unity3d.services.core.configuration.ConfigurationReader;
import com.unity3d.services.core.configuration.InitRequestType;
import com.unity3d.services.core.configuration.PrivacyConfigStorage;
import com.unity3d.services.core.device.reader.DeviceInfoReaderCompressor;
import com.unity3d.services.core.device.reader.DeviceInfoReaderCompressorWithMetrics;
import com.unity3d.services.core.device.reader.GameSessionIdReader;
import com.unity3d.services.core.device.reader.IDeviceInfoDataContainer;
import com.unity3d.services.core.device.reader.builder.DeviceInfoReaderBuilder;
import com.unity3d.services.core.device.reader.builder.DeviceInfoReaderPrivacyBuilder;
import com.unity3d.services.core.request.metrics.SDKMetricsSender;

public class DeviceInfoDataFactory {
    private final SDKMetricsSender _sdkMetricsSender;

    public DeviceInfoDataFactory(SDKMetricsSender sdkMetricsSender) {
        this._sdkMetricsSender = sdkMetricsSender;
    }

    public IDeviceInfoDataContainer getDeviceInfoData(InitRequestType callType) {
        switch (callType) {
            case TOKEN: {
                return this.getTokenDeviceInfoData();
            }
            case PRIVACY: {
                return this.getPrivacyDeviceInfoData();
            }
        }
        return null;
    }

    private IDeviceInfoDataContainer getPrivacyDeviceInfoData() {
        PrivacyConfigStorage privacyConfigStorage = PrivacyConfigStorage.getInstance();
        DeviceInfoReaderPrivacyBuilder deviceInfoReaderPrivacyBuilder = new DeviceInfoReaderPrivacyBuilder(new ConfigurationReader(), privacyConfigStorage, GameSessionIdReader.getInstance());
        return new DeviceInfoReaderCompressor(((DeviceInfoReaderBuilder)deviceInfoReaderPrivacyBuilder).build());
    }

    private IDeviceInfoDataContainer getTokenDeviceInfoData() {
        PrivacyConfigStorage privacyConfigStorage = PrivacyConfigStorage.getInstance();
        DeviceInfoReaderBuilder deviceInfoReaderBuilder = new DeviceInfoReaderBuilder(new ConfigurationReader(), privacyConfigStorage, GameSessionIdReader.getInstance());
        return new DeviceInfoReaderCompressorWithMetrics(new DeviceInfoReaderCompressor(deviceInfoReaderBuilder.build()), this._sdkMetricsSender);
    }
}

