/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.timer;

import com.unity3d.services.core.lifecycle.LifecycleCache;
import com.unity3d.services.core.timer.BaseTimer;
import com.unity3d.services.core.timer.IIntervalTimer;
import com.unity3d.services.core.timer.IIntervalTimerListener;
import java.util.concurrent.atomic.AtomicInteger;

public class IntervalTimer
extends BaseTimer
implements IIntervalTimer {
    private final Integer _totalIntervals;
    private final Integer _intervalDuration;
    private Integer _nextInterval;
    private IIntervalTimerListener _timerListener;
    private final AtomicInteger _currentPosition = new AtomicInteger(0);

    public IntervalTimer(Integer totalDurationMs, Integer totalIntervals, IIntervalTimerListener timerListener, LifecycleCache lifecycleCache) {
        super(totalDurationMs, null, lifecycleCache);
        this._totalIntervals = totalIntervals;
        this._timerListener = timerListener;
        this._nextInterval = this._intervalDuration = Integer.valueOf(this._totalIntervals == 0 ? totalDurationMs : totalDurationMs / this._totalIntervals);
    }

    @Override
    public void onStep() {
        if (this._currentPosition.addAndGet(this._delayMs) >= this._nextInterval) {
            this.onNextInterval();
        }
        super.onStep();
    }

    @Override
    public void onNextInterval() {
        if (this._timerListener != null) {
            this._timerListener.onNextIntervalTriggered();
        }
        this._nextInterval = this._nextInterval + this._intervalDuration;
    }

    @Override
    public void kill() {
        super.kill();
        this._timerListener = null;
    }
}

