/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.device.reader;

import android.app.Activity;
import android.content.res.Configuration;
import android.os.Build;
import android.view.Display;
import android.view.WindowManager;
import com.unity3d.services.core.configuration.ExperimentsReader;
import com.unity3d.services.core.device.reader.IHdrInfoReader;
import com.unity3d.services.core.misc.Utilities;
import com.unity3d.services.core.request.metrics.Metric;
import com.unity3d.services.core.request.metrics.SDKMetricsSender;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;

public class HdrInfoReader
implements IHdrInfoReader {
    private final SDKMetricsSender _sdkMetricsSender = (SDKMetricsSender)Utilities.getService(SDKMetricsSender.class);
    private static final AtomicBoolean _hdrMetricsCaptured = new AtomicBoolean(false);
    private static volatile HdrInfoReader _instance;

    private HdrInfoReader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HdrInfoReader getInstance() {
        if (_instance != null) return _instance;
        Class<HdrInfoReader> clazz = HdrInfoReader.class;
        synchronized (HdrInfoReader.class) {
            if (_instance != null) return _instance;
            _instance = new HdrInfoReader();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _instance;
        }
    }

    @Override
    public void captureHDRCapabilityMetrics(Activity activity, ExperimentsReader experimentsReader) {
        if (activity == null) {
            return;
        }
        if (!experimentsReader.getCurrentlyActiveExperiments().isCaptureHDRCapabilitiesEnabled()) {
            return;
        }
        if (_hdrMetricsCaptured.compareAndSet(false, true)) {
            ArrayList<Metric> hdrMetrics = new ArrayList<Metric>(5);
            boolean hasDolbyVision = false;
            boolean hasHDR10 = false;
            boolean hasHDR10Plus = false;
            boolean hasHLG = false;
            boolean isScreenHDR = false;
            if (Build.VERSION.SDK_INT >= 24) {
                int[] types;
                Display display = ((WindowManager)activity.getSystemService("window")).getDefaultDisplay();
                Display.HdrCapabilities hdrCapabilities = display.getHdrCapabilities();
                block6: for (int type : types = hdrCapabilities.getSupportedHdrTypes()) {
                    switch (type) {
                        case 1: {
                            hasDolbyVision = true;
                            continue block6;
                        }
                        case 2: {
                            hasHDR10 = true;
                            continue block6;
                        }
                        case 3: {
                            hasHLG = true;
                            continue block6;
                        }
                        case 4: {
                            hasHDR10Plus = true;
                        }
                    }
                }
                long maxAverage = Math.round(hdrCapabilities.getDesiredMaxAverageLuminance());
                long maxLum = Math.round(hdrCapabilities.getDesiredMaxLuminance());
                long minLum = Math.round(hdrCapabilities.getDesiredMinLuminance());
                hdrMetrics.add(new Metric("native_device_hdr_lum_max_average", maxAverage));
                hdrMetrics.add(new Metric("native_device_hdr_lum_max", maxLum));
                hdrMetrics.add(new Metric("native_device_hdr_lum_min", minLum));
                if (Build.VERSION.SDK_INT >= 26) {
                    Configuration configuration = activity.getResources().getConfiguration();
                    isScreenHDR = configuration.isScreenHdr();
                }
            }
            if (hasDolbyVision) {
                hdrMetrics.add(new Metric("native_device_hdr_dolby_vision_success"));
            } else {
                hdrMetrics.add(new Metric("native_device_hdr_dolby_vision_failure"));
            }
            if (hasHDR10) {
                hdrMetrics.add(new Metric("native_device_hdr_hdr10_success"));
            } else {
                hdrMetrics.add(new Metric("native_device_hdr_hdr10_failure"));
            }
            if (hasHDR10Plus) {
                hdrMetrics.add(new Metric("native_device_hdr_hdr10_plus_success"));
            } else {
                hdrMetrics.add(new Metric("native_device_hdr_hdr10_plus_failure"));
            }
            if (hasHLG) {
                hdrMetrics.add(new Metric("native_device_hdr_hlg_success"));
            } else {
                hdrMetrics.add(new Metric("native_device_hdr_hlg_failure"));
            }
            if (isScreenHDR) {
                hdrMetrics.add(new Metric("native_device_hdr_screen_hdr_success"));
            } else {
                hdrMetrics.add(new Metric("native_device_hdr_screen_hdr_failure"));
            }
            this._sdkMetricsSender.sendMetrics(hdrMetrics);
        }
    }
}

