/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.device.reader;

import com.unity3d.services.core.device.Storage;
import com.unity3d.services.core.device.StorageManager;
import com.unity3d.services.core.device.reader.IGameSessionIdReader;
import com.unity3d.services.core.properties.ClientProperties;
import java.util.UUID;

public class GameSessionIdReader
implements IGameSessionIdReader {
    private static final int GAME_SESSION_ID_LENGTH = 12;
    private static volatile GameSessionIdReader _instance;
    private Long gameSessionId;

    private GameSessionIdReader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GameSessionIdReader getInstance() {
        if (_instance != null) return _instance;
        Class<GameSessionIdReader> clazz = GameSessionIdReader.class;
        synchronized (GameSessionIdReader.class) {
            if (_instance != null) return _instance;
            _instance = new GameSessionIdReader();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _instance;
        }
    }

    @Override
    public synchronized Long getGameSessionId() {
        if (this.gameSessionId == null) {
            this.generate();
        }
        return this.gameSessionId;
    }

    @Override
    public synchronized Long getGameSessionIdAndStore() {
        if (this.gameSessionId == null) {
            this.generate();
            this.store();
        }
        return this.gameSessionId;
    }

    private void generate() {
        UUID id = UUID.randomUUID();
        String numericUUID = Long.toString(id.getMostSignificantBits()) + Long.toString(id.getLeastSignificantBits());
        this.gameSessionId = Long.valueOf(numericUUID.replace("-", "").substring(0, 12));
    }

    private void store() {
        Storage storage;
        if (StorageManager.init(ClientProperties.getApplicationContext()) && (storage = StorageManager.getStorage(StorageManager.StorageType.PRIVATE)) != null) {
            storage.set("unifiedconfig.data.gameSessionId", this.gameSessionId);
            storage.writeStorage();
        }
    }
}

