/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.broadcast;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import com.unity3d.services.core.broadcast.BroadcastEventReceiver;
import com.unity3d.services.core.properties.ClientProperties;
import java.util.HashMap;
import java.util.Map;

public class BroadcastMonitor {
    private static BroadcastMonitor _instance;
    private Map<String, BroadcastEventReceiver> _eventReceivers;
    private final Context _context;

    public static synchronized BroadcastMonitor getInstance() {
        if (_instance == null) {
            _instance = new BroadcastMonitor(ClientProperties.getApplicationContext());
        }
        return _instance;
    }

    private BroadcastMonitor(Context context) {
        this._context = context;
    }

    public void addBroadcastListener(String name, String dataScheme, String[] actions) {
        this.removeBroadcastListener(name);
        IntentFilter filter2 = new IntentFilter();
        for (String action : actions) {
            filter2.addAction(action);
        }
        if (dataScheme != null) {
            filter2.addDataScheme(dataScheme);
        }
        if (this._eventReceivers == null) {
            this._eventReceivers = new HashMap<String, BroadcastEventReceiver>();
        }
        BroadcastEventReceiver eventReceiver = new BroadcastEventReceiver(name);
        this._eventReceivers.put(name, eventReceiver);
        this._context.registerReceiver((BroadcastReceiver)eventReceiver, filter2);
    }

    public void removeBroadcastListener(String name) {
        if (this._eventReceivers != null && this._eventReceivers.containsKey(name)) {
            this._context.unregisterReceiver((BroadcastReceiver)this._eventReceivers.get(name));
            this._eventReceivers.remove(name);
        }
    }

    public void removeAllBroadcastListeners() {
        if (this._eventReceivers != null) {
            for (String key : this._eventReceivers.keySet()) {
                this._context.unregisterReceiver((BroadcastReceiver)this._eventReceivers.get(key));
            }
            this._eventReceivers = null;
        }
    }
}

