/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.banners.bridge;

import com.unity3d.ads.IUnityAdsLoadListener;
import com.unity3d.ads.UnityAds;
import com.unity3d.ads.UnityAdsLoadOptions;
import com.unity3d.ads.UnityAdsShowOptions;
import com.unity3d.ads.core.configuration.AlternativeFlowReader;
import com.unity3d.ads.core.data.model.Listeners;
import com.unity3d.services.UnityAdsSDK;
import com.unity3d.services.ads.operation.load.LoadBannerModule;
import com.unity3d.services.ads.operation.load.LoadBannerOperationState;
import com.unity3d.services.banners.BannerErrorCode;
import com.unity3d.services.banners.BannerErrorInfo;
import com.unity3d.services.banners.BannerView;
import com.unity3d.services.banners.BannerViewCache;
import com.unity3d.services.banners.UnityBannerSize;
import com.unity3d.services.core.configuration.ConfigurationReader;
import com.unity3d.services.core.misc.Utilities;
import com.unity3d.services.core.request.metrics.Metric;
import com.unity3d.services.core.request.metrics.SDKMetricsSender;
import com.unity3d.services.core.webview.WebViewApp;
import com.unity3d.services.core.webview.WebViewEventCategory;
import com.unity3d.services.core.webview.bridge.WebViewBridgeInvoker;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

public class BannerBridge {
    public static void load(String placementId, String bannerAdId, UnityBannerSize bannerSize) {
        WebViewApp webViewApp = WebViewApp.getCurrentApp();
        if (webViewApp != null) {
            webViewApp.sendEvent(WebViewEventCategory.BANNER, BannerEvent.BANNER_LOAD_PLACEMENT, placementId, bannerAdId, bannerSize.getWidth(), bannerSize.getHeight());
        } else {
            BannerView bannerAdView = BannerViewCache.getInstance().getBannerView(bannerAdId);
            if (bannerAdView != null && bannerAdView.getListener() != null) {
                bannerAdView.getListener().onBannerFailedToLoad(bannerAdView, new BannerErrorInfo("WebViewApp was not available, this is likely because UnityAds has not been initialized", BannerErrorCode.WEBVIEW_ERROR));
            }
        }
    }

    public static void load(String placementId, final String bannerAdId, UnityBannerSize bannerSize, final UnityAdsLoadOptions loadOptions) {
        boolean hasObjectId;
        final SDKMetricsSender sdkMetricsSender = (SDKMetricsSender)Utilities.getService(SDKMetricsSender.class);
        final boolean isHB = BannerBridge.isHeaderBidding(loadOptions.getData());
        final HashMap<String, String> tags = new HashMap<String, String>(){
            {
                this.put("is_header_bidding", String.valueOf(isHB));
            }
        };
        final BannerView bannerAdView = BannerViewCache.getInstance().getBannerView(bannerAdId);
        if (bannerAdView == null) {
            sdkMetricsSender.sendMetricWithInitState(new Metric("native_banner_load_not_found", null, (Map<String, String>)tags));
            return;
        }
        AlternativeFlowReader alternativeFlowReader = (AlternativeFlowReader)Utilities.getService(AlternativeFlowReader.class);
        final boolean isAlternativeFlow = alternativeFlowReader.invoke();
        boolean bl = hasObjectId = loadOptions.getObjectId() != null;
        if (isAlternativeFlow && !hasObjectId) {
            loadOptions.setObjectId(bannerAdId);
        }
        final BannerView.IListener bannerListener = bannerAdView.getListener();
        IUnityAdsLoadListener listener2 = new IUnityAdsLoadListener(){

            @Override
            public void onUnityAdsAdLoaded(String placementId) {
                if (bannerListener == null) {
                    sdkMetricsSender.sendMetricWithInitState(new Metric("native_banner_listener_loaded_not_found", null, tags));
                }
                if (isAlternativeFlow) {
                    if (bannerListener != null) {
                        bannerListener.onBannerLoaded(bannerAdView);
                    }
                    UnityAdsShowOptions showOptions = new UnityAdsShowOptions();
                    showOptions.setObjectId(loadOptions.getObjectId());
                    UnityAdsSDK.INSTANCE.show(placementId, showOptions, new Listeners(){

                        @Override
                        public void onLeftApplication(@NotNull String placementId) {
                            if (bannerListener != null) {
                                bannerListener.onBannerLeftApplication(bannerAdView);
                            }
                        }

                        @Override
                        public void onComplete(@NotNull String placementId, @NotNull UnityAds.UnityAdsShowCompletionState state) {
                        }

                        @Override
                        public void onClick(@NotNull String placementId) {
                            if (bannerListener != null) {
                                bannerListener.onBannerClick(bannerAdView);
                            }
                        }

                        @Override
                        public void onStart(@NotNull String placementId) {
                            if (bannerListener != null) {
                                bannerListener.onBannerShown(bannerAdView);
                            }
                        }

                        @Override
                        public void onError(@NotNull String placementId, @NotNull UnityAds.UnityAdsShowError error2, @NotNull String message) {
                        }
                    });
                }
            }

            @Override
            public void onUnityAdsFailedToLoad(String placementId, UnityAds.UnityAdsLoadError error2, String message) {
                BannerView bannerAdView2 = BannerViewCache.getInstance().getBannerView(bannerAdId);
                if (bannerAdView2 == null || bannerAdView2.getListener() == null) {
                    sdkMetricsSender.sendMetricWithInitState(new Metric("native_banner_listener_load_fail_not_found", null, tags));
                    return;
                }
                BannerErrorInfo bannerErrorInfo = BannerErrorInfo.fromLoadError(error2, message);
                bannerAdView2.getListener().onBannerFailedToLoad(bannerAdView2, bannerErrorInfo);
            }
        };
        if (isAlternativeFlow) {
            UnityAdsSDK.INSTANCE.load(placementId, loadOptions, listener2, bannerSize);
            return;
        }
        LoadBannerModule.getInstance().executeAdOperation(new WebViewBridgeInvoker(), new LoadBannerOperationState(placementId, bannerAdId, bannerSize, listener2, loadOptions, new ConfigurationReader().getCurrentConfiguration()));
    }

    private static boolean isHeaderBidding(JSONObject data) {
        if (data == null) {
            return false;
        }
        return data.has("adMarkup");
    }

    public static void destroy(String bannerAdId) {
        WebViewApp webViewApp = WebViewApp.getCurrentApp();
        if (webViewApp != null) {
            webViewApp.sendEvent(WebViewEventCategory.BANNER, BannerEvent.BANNER_DESTROY_BANNER, bannerAdId);
        }
    }

    public static void resize(String bannerAdId, int left, int top, int right, int bottom, float alpha) {
        WebViewApp webViewApp = WebViewApp.getCurrentApp();
        if (webViewApp != null) {
            webViewApp.sendEvent(WebViewEventCategory.BANNER, BannerEvent.BANNER_RESIZED, bannerAdId, left, top, right, bottom, Float.valueOf(alpha));
        }
    }

    public static void visibilityChanged(String bannerAdId, int visibility) {
        WebViewApp webViewApp = WebViewApp.getCurrentApp();
        if (webViewApp != null) {
            webViewApp.sendEvent(WebViewEventCategory.BANNER, BannerEvent.BANNER_VISIBILITY_CHANGED, bannerAdId, visibility);
        }
    }

    public static void didLoad(String bannerAdId) {
        WebViewApp webViewApp = WebViewApp.getCurrentApp();
        if (webViewApp != null) {
            webViewApp.sendEvent(WebViewEventCategory.BANNER, BannerEvent.BANNER_LOADED, bannerAdId);
        }
    }

    public static void didDestroy(String bannerAdId) {
        WebViewApp webViewApp = WebViewApp.getCurrentApp();
        if (webViewApp != null) {
            webViewApp.sendEvent(WebViewEventCategory.BANNER, BannerEvent.BANNER_DESTROYED, bannerAdId);
        }
    }

    public static void didAttach(String bannerAdId) {
        WebViewApp webViewApp = WebViewApp.getCurrentApp();
        if (webViewApp != null) {
            webViewApp.sendEvent(WebViewEventCategory.BANNER, BannerEvent.BANNER_ATTACHED, bannerAdId);
        }
    }

    public static void didDetach(String bannerAdId) {
        WebViewApp webViewApp = WebViewApp.getCurrentApp();
        if (webViewApp != null) {
            webViewApp.sendEvent(WebViewEventCategory.BANNER, BannerEvent.BANNER_DETACHED, bannerAdId);
        }
    }

    public static void didAttachScarBanner(String bannerAdId) {
        WebViewApp webViewApp = WebViewApp.getCurrentApp();
        if (webViewApp != null) {
            webViewApp.sendEvent(WebViewEventCategory.BANNER, BannerEvent.SCAR_BANNER_ATTACHED, bannerAdId);
        }
    }

    public static void didDetachScarBanner(String bannerAdId) {
        WebViewApp webViewApp = WebViewApp.getCurrentApp();
        if (webViewApp != null) {
            webViewApp.sendEvent(WebViewEventCategory.BANNER, BannerEvent.SCAR_BANNER_DETACHED, bannerAdId);
        }
    }

    public static enum BannerEvent {
        BANNER_VISIBILITY_CHANGED,
        BANNER_RESIZED,
        BANNER_LOADED,
        BANNER_DESTROYED,
        BANNER_ATTACHED,
        BANNER_DETACHED,
        BANNER_LOAD_PLACEMENT,
        BANNER_DESTROY_BANNER,
        SCAR_BANNER_LOADED,
        SCAR_BANNER_LOAD_FAILED,
        SCAR_BANNER_ATTACHED,
        SCAR_BANNER_DETACHED,
        SCAR_BANNER_OPENED,
        SCAR_BANNER_CLOSED,
        SCAR_BANNER_IMPRESSION,
        SCAR_BANNER_CLICKED;

    }
}

