/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.ads.webplayer;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.net.http.SslError;
import android.os.Build;
import android.os.Message;
import android.view.KeyEvent;
import android.view.View;
import android.webkit.ClientCertRequest;
import android.webkit.ConsoleMessage;
import android.webkit.DownloadListener;
import android.webkit.GeolocationPermissions;
import android.webkit.HttpAuthHandler;
import android.webkit.JsPromptResult;
import android.webkit.JsResult;
import android.webkit.PermissionRequest;
import android.webkit.RenderProcessGoneDetail;
import android.webkit.SslErrorHandler;
import android.webkit.ValueCallback;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.unity3d.services.ads.webplayer.WebPlayerBridgeInterface;
import com.unity3d.services.ads.webplayer.WebPlayerEvent;
import com.unity3d.services.ads.webplayer.WebPlayerEventBridge;
import com.unity3d.services.ads.webplayer.WebPlayerViewCache;
import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.misc.Utilities;
import com.unity3d.services.core.misc.ViewUtilities;
import com.unity3d.services.core.webview.WebViewApp;
import com.unity3d.services.core.webview.WebViewEventCategory;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class WebPlayerView
extends WebView {
    private Map<String, String> _erroredSettings;
    private JSONObject _eventSettings;
    private Method _evaluateJavascript = null;
    private String viewId;
    private Runnable _unsubscribeLayoutChange = null;

    public WebPlayerView(Context context, String viewId, JSONObject webSettings, JSONObject webPlayerSettings) {
        super(context);
        this.viewId = viewId;
        WebSettings settings = this.getSettings();
        if (Build.VERSION.SDK_INT >= 16) {
            settings.setAllowFileAccessFromFileURLs(false);
            settings.setAllowUniversalAccessFromFileURLs(false);
        }
        if (Build.VERSION.SDK_INT >= 19) {
            try {
                this._evaluateJavascript = WebView.class.getMethod("evaluateJavascript", String.class, ValueCallback.class);
            }
            catch (NoSuchMethodException e) {
                DeviceLog.exception("Method evaluateJavascript not found", e);
                this._evaluateJavascript = null;
            }
        }
        settings.setCacheMode(2);
        settings.setDatabaseEnabled(false);
        settings.setDomStorageEnabled(false);
        settings.setGeolocationEnabled(false);
        settings.setJavaScriptEnabled(true);
        settings.setLoadsImagesAutomatically(true);
        settings.setPluginState(WebSettings.PluginState.OFF);
        settings.setRenderPriority(WebSettings.RenderPriority.NORMAL);
        settings.setSaveFormData(false);
        settings.setSavePassword(false);
        this.setHorizontalScrollBarEnabled(false);
        this.setVerticalScrollBarEnabled(false);
        this.setInitialScale(0);
        this.setBackgroundColor(0);
        ViewUtilities.setBackground((View)this, (Drawable)new ColorDrawable(0));
        this.setBackgroundResource(0);
        this.setSettings(webSettings, webPlayerSettings);
        this.setWebViewClient(new WebPlayerClient());
        this.setWebChromeClient(new WebPlayerChromeClient());
        this.setDownloadListener(new WebPlayerDownloadListener());
        this.addJavascriptInterface(new WebPlayerBridgeInterface(viewId), "webplayerbridge");
        WebPlayerViewCache.getInstance().addWebPlayer(viewId, this);
        this.subscribeOnLayoutChange();
    }

    private void subscribeOnLayoutChange() {
        if (this._unsubscribeLayoutChange != null) {
            this._unsubscribeLayoutChange.run();
        }
        if (Build.VERSION.SDK_INT >= 11) {
            final View.OnLayoutChangeListener onLayoutChangeListener = new View.OnLayoutChangeListener(){

                public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                    WebPlayerView.this.onLayoutChange();
                }
            };
            this.addOnLayoutChangeListener(onLayoutChangeListener);
            this._unsubscribeLayoutChange = new Runnable(){

                @Override
                public void run() {
                    WebPlayerView.this.removeOnLayoutChangeListener(onLayoutChangeListener);
                }
            };
        }
    }

    public void destroy() {
        super.destroy();
        WebPlayerViewCache.getInstance().removeWebPlayer(this.viewId);
        if (this._unsubscribeLayoutChange != null) {
            this._unsubscribeLayoutChange.run();
        }
    }

    public void setEventSettings(JSONObject eventSettings) {
        this._eventSettings = eventSettings;
    }

    public void setSettings(JSONObject webSettings, JSONObject webPlayerSettings) {
        if (this._erroredSettings != null) {
            this._erroredSettings.clear();
        }
        WebSettings settings = this.getSettings();
        this.setTargetSettings(settings, webSettings);
        this.setTargetSettings((Object)this, webPlayerSettings);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.onLayoutChange();
    }

    public void onLayoutChange() {
        int[] location = new int[2];
        this.getLocationOnScreen(location);
        int x = location[0];
        int y = location[1];
        int width = this.getWidth();
        int height = this.getHeight();
        float alpha = 1.0f;
        if (Build.VERSION.SDK_INT >= 11) {
            alpha = this.getAlpha();
        }
        WebPlayerEventBridge.sendFrameUpdate(this.viewId, x, y, width, height, alpha);
    }

    public Map<String, String> getErroredSettings() {
        return this._erroredSettings;
    }

    private Object setTargetSettings(Object targetObj, JSONObject settings) {
        if (settings != null) {
            Iterator keysIterator = settings.keys();
            while (keysIterator.hasNext()) {
                String key = (String)keysIterator.next();
                try {
                    JSONArray parameters = settings.getJSONArray(key);
                    Class<?>[] types = this.getTypes(parameters);
                    Method m = targetObj.getClass().getMethod(key, types);
                    m.invoke(targetObj, this.getValues(parameters));
                }
                catch (Exception e) {
                    this.addErroredSetting(key, e.getMessage());
                    DeviceLog.exception("Setting errored", e);
                }
            }
        }
        return targetObj;
    }

    public void invokeJavascript(String data) {
        Utilities.runOnUiThread(new JavaScriptInvocation(data, this));
    }

    public void sendEvent(JSONArray params) {
        StringBuilder builder = new StringBuilder();
        builder.append("javascript:window.nativebridge.receiveEvent(");
        builder.append(params.toString());
        builder.append(")");
        this.invokeJavascript(builder.toString());
    }

    private Class<?>[] getTypes(JSONArray parameters) throws JSONException, ClassNotFoundException {
        if (parameters == null) {
            return null;
        }
        Class[] types = new Class[parameters.length()];
        if (parameters != null) {
            for (int i = 0; i < parameters.length(); ++i) {
                if (parameters.get(i) instanceof JSONObject) {
                    JSONObject param = (JSONObject)parameters.get(i);
                    String className = param.getString("className");
                    Class<?> theClass = Class.forName(className);
                    if (theClass == null) continue;
                    types[i] = theClass;
                    continue;
                }
                Class<?> currentClass = parameters.get(i).getClass();
                types[i] = this.getPrimitiveClass(currentClass);
            }
        }
        return types;
    }

    public Class<?> getPrimitiveClass(Class<?> className) {
        String typeName = className.getName();
        if (typeName.equals("java.lang.Byte")) {
            return Byte.TYPE;
        }
        if (typeName.equals("java.lang.Short")) {
            return Short.TYPE;
        }
        if (typeName.equals("java.lang.Integer")) {
            return Integer.TYPE;
        }
        if (typeName.equals("java.lang.Long")) {
            return Long.TYPE;
        }
        if (typeName.equals("java.lang.Character")) {
            return Character.TYPE;
        }
        if (typeName.equals("java.lang.Float")) {
            return Float.TYPE;
        }
        if (typeName.equals("java.lang.Double")) {
            return Double.TYPE;
        }
        if (typeName.equals("java.lang.Boolean")) {
            return Boolean.TYPE;
        }
        if (typeName.equals("java.lang.Void")) {
            return Void.TYPE;
        }
        return className;
    }

    private Object[] getValues(JSONArray parameters) throws JSONException, ClassNotFoundException, NoSuchMethodException {
        if (parameters == null) {
            return null;
        }
        Object[] values = new Object[parameters.length()];
        Object[] params = new Object[parameters.length()];
        for (int i = 0; i < parameters.length(); ++i) {
            if (parameters.get(i) instanceof JSONObject) {
                Class<?> enumClass;
                JSONObject param = (JSONObject)parameters.get(i);
                Object value = param.get("value");
                String type = param.getString("type");
                String className = null;
                if (param.has("className")) {
                    className = param.getString("className");
                }
                if (className == null || !type.equals("Enum") || (enumClass = Class.forName(className)) == null) continue;
                params[i] = Enum.valueOf(enumClass, (String)value);
                continue;
            }
            params[i] = parameters.get(i);
        }
        if (parameters != null) {
            System.arraycopy(params, 0, values, 0, parameters.length());
        }
        return values;
    }

    private void addErroredSetting(String key, String error2) {
        if (this._erroredSettings == null) {
            this._erroredSettings = new HashMap<String, String>();
        }
        this._erroredSettings.put(key, error2);
    }

    private boolean shouldCallSuper(String event) {
        try {
            if (this._eventSettings != null && this._eventSettings.has(event) && this._eventSettings.getJSONObject(event).has("callSuper")) {
                return this._eventSettings.getJSONObject(event).getBoolean("callSuper");
            }
        }
        catch (Exception e) {
            DeviceLog.exception("Error getting super call status", e);
        }
        return true;
    }

    private boolean shouldSendEvent(String event) {
        try {
            if (this._eventSettings != null && this._eventSettings.has(event) && this._eventSettings.getJSONObject(event).has("sendEvent")) {
                return this._eventSettings.getJSONObject(event).getBoolean("sendEvent");
            }
        }
        catch (Exception e) {
            DeviceLog.exception("Error getting send event status", e);
        }
        return false;
    }

    private <T> T getReturnValue(String event, Class<T> type, T defaultValue) {
        try {
            if (this._eventSettings != null && this._eventSettings.has(event) && this._eventSettings.getJSONObject(event).has("returnValue")) {
                return type.cast(this._eventSettings.getJSONObject(event).get("returnValue"));
            }
        }
        catch (Exception e) {
            DeviceLog.exception("Error getting default return value", e);
        }
        return defaultValue;
    }

    private boolean hasReturnValue(String event) {
        try {
            if (this._eventSettings != null && this._eventSettings.has(event) && this._eventSettings.getJSONObject(event).has("returnValue")) {
                return true;
            }
        }
        catch (Exception e) {
            DeviceLog.exception("Error getting default return value", e);
        }
        return false;
    }

    private class WebPlayerClient
    extends WebViewClient {
        private WebPlayerClient() {
        }

        public boolean onRenderProcessGone(final WebView view, RenderProcessGoneDetail detail) {
            Utilities.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    ViewUtilities.removeViewFromParent((View)view);
                    view.destroy();
                }
            });
            WebPlayerEventBridge.error(WebPlayerView.this.viewId, WebPlayerView.this.getUrl(), "UnityAds Sdk WebPlayer onRenderProcessGone : " + detail.toString());
            DeviceLog.error("UnityAds Sdk WebPlayer onRenderProcessGone : " + detail.toString());
            return true;
        }

        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            if (WebPlayerView.this.shouldCallSuper("onPageStarted")) {
                super.onPageStarted(view, url, favicon);
            }
            if (WebPlayerView.this.shouldSendEvent("onPageStarted")) {
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.WEBPLAYER, WebPlayerEvent.PAGE_STARTED, url, WebPlayerView.this.viewId);
            }
        }

        public void onPageFinished(WebView view, String url) {
            if (WebPlayerView.this.shouldCallSuper("onPageFinished")) {
                super.onPageFinished(view, url);
            }
            if (WebPlayerView.this.shouldSendEvent("onPageFinished")) {
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.WEBPLAYER, WebPlayerEvent.PAGE_FINISHED, url, WebPlayerView.this.viewId);
            }
        }

        public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
            if (WebPlayerView.this.shouldCallSuper("onReceivedError")) {
                super.onReceivedError(view, errorCode, description, failingUrl);
            }
            if (WebPlayerView.this.shouldSendEvent("onReceivedError")) {
                WebPlayerEventBridge.error(WebPlayerView.this.viewId, failingUrl, description);
            }
        }

        @TargetApi(value=25)
        public void onReceivedError(WebView view, WebResourceRequest request2, WebResourceError error2) {
            if (WebPlayerView.this.shouldCallSuper("onReceivedError")) {
                super.onReceivedError(view, request2, error2);
            }
            if (WebPlayerView.this.shouldSendEvent("onReceivedError")) {
                String description = "";
                if (error2 != null && error2.getDescription() != null) {
                    description = error2.getDescription().toString();
                }
                String url = "";
                if (request2 != null && request2.getUrl() != null) {
                    url = request2.getUrl().toString();
                }
                WebPlayerEventBridge.error(WebPlayerView.this.viewId, url, description);
            }
        }

        public void onLoadResource(WebView view, String url) {
            if (WebPlayerView.this.shouldCallSuper("onLoadResource")) {
                super.onLoadResource(view, url);
            }
            if (WebPlayerView.this.shouldSendEvent("onLoadResource")) {
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.WEBPLAYER, WebPlayerEvent.LOAD_RESOUCE, url, WebPlayerView.this.viewId);
            }
        }

        @TargetApi(value=14)
        public void onReceivedSslError(WebView view, SslErrorHandler handler, SslError error2) {
            super.onReceivedSslError(view, handler, error2);
            if (error2 != null) {
                DeviceLog.error("Received SSL error for '%s': %s", error2.getUrl(), error2.toString());
            } else {
                DeviceLog.error("Received unknown SSL error: SslError was null");
            }
            if (WebPlayerView.this.shouldSendEvent("onReceivedSslError")) {
                String url = "";
                if (error2 != null) {
                    url = error2.getUrl();
                }
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.WEBPLAYER, WebPlayerEvent.SSL_ERROR, url, WebPlayerView.this.viewId);
            }
        }

        @TargetApi(value=21)
        public void onReceivedClientCertRequest(WebView view, ClientCertRequest request2) {
            if (WebPlayerView.this.shouldCallSuper("onReceivedClientCertRequest")) {
                super.onReceivedClientCertRequest(view, request2);
            }
            if (WebPlayerView.this.shouldSendEvent("onReceivedClientCertRequest")) {
                String host = "";
                int port = -1;
                if (request2 != null) {
                    host = request2.getHost();
                    port = request2.getPort();
                }
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.WEBPLAYER, WebPlayerEvent.CLIENT_CERT_REQUEST, host, port, WebPlayerView.this.viewId);
            }
        }

        public void onReceivedHttpAuthRequest(WebView view, HttpAuthHandler handler, String host, String realm) {
            if (WebPlayerView.this.shouldCallSuper("onReceivedHttpAuthRequest")) {
                super.onReceivedHttpAuthRequest(view, handler, host, realm);
            }
            if (WebPlayerView.this.shouldSendEvent("onReceivedHttpAuthRequest")) {
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.WEBPLAYER, WebPlayerEvent.HTTP_AUTH_REQUEST, host, realm, WebPlayerView.this.viewId);
            }
        }

        public void onScaleChanged(WebView view, float oldScale, float newScale) {
            if (WebPlayerView.this.shouldCallSuper("onScaleChanged")) {
                super.onScaleChanged(view, oldScale, newScale);
            }
            if (WebPlayerView.this.shouldSendEvent("onScaleChanged")) {
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.WEBPLAYER, WebPlayerEvent.SCALE_CHANGED, Float.valueOf(oldScale), Float.valueOf(newScale), WebPlayerView.this.viewId);
            }
        }

        public void onReceivedLoginRequest(WebView view, String realm, String account, String args) {
            if (WebPlayerView.this.shouldCallSuper("onReceivedLoginRequest")) {
                super.onReceivedLoginRequest(view, realm, account, args);
            }
            if (WebPlayerView.this.shouldSendEvent("onReceivedLoginRequest")) {
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.WEBPLAYER, WebPlayerEvent.LOGIN_REQUEST, realm, account, args, WebPlayerView.this.viewId);
            }
        }

        @TargetApi(value=21)
        public void onReceivedHttpError(WebView view, WebResourceRequest request2, WebResourceResponse errorResponse) {
            if (WebPlayerView.this.shouldCallSuper("onReceivedHttpError")) {
                super.onReceivedHttpError(view, request2, errorResponse);
            }
            if (WebPlayerView.this.shouldSendEvent("onReceivedHttpError")) {
                String url = "";
                if (request2 != null && request2.getUrl() != null) {
                    url = request2.getUrl().toString();
                }
                int statusCode = -1;
                String reasonPhrase = "";
                if (errorResponse != null) {
                    statusCode = errorResponse.getStatusCode();
                    reasonPhrase = errorResponse.getReasonPhrase();
                }
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.WEBPLAYER, WebPlayerEvent.HTTP_ERROR, url, reasonPhrase, statusCode, WebPlayerView.this.viewId);
            }
        }

        @TargetApi(value=21)
        public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request2) {
            Boolean returnValue = false;
            if (WebPlayerView.this.shouldCallSuper("shouldOverrideUrlLoading")) {
                returnValue = super.shouldOverrideUrlLoading(view, request2);
            }
            if (WebPlayerView.this.shouldSendEvent("shouldOverrideUrlLoading")) {
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.WEBPLAYER, WebPlayerEvent.SHOULD_OVERRIDE_URL_LOADING, request2.getUrl().toString(), request2.getMethod(), WebPlayerView.this.viewId);
            }
            if (WebPlayerView.this.hasReturnValue("shouldOverrideUrlLoading")) {
                returnValue = (Boolean)WebPlayerView.this.getReturnValue("shouldOverrideUrlLoading", Boolean.class, true);
            }
            return returnValue;
        }

        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            Boolean returnValue = false;
            if (WebPlayerView.this.shouldCallSuper("shouldOverrideUrlLoading")) {
                returnValue = super.shouldOverrideUrlLoading(view, url);
            }
            if (WebPlayerView.this.shouldSendEvent("shouldOverrideUrlLoading")) {
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.WEBPLAYER, WebPlayerEvent.SHOULD_OVERRIDE_URL_LOADING, url, WebPlayerView.this.viewId);
            }
            if (WebPlayerView.this.hasReturnValue("shouldOverrideUrlLoading")) {
                returnValue = (Boolean)WebPlayerView.this.getReturnValue("shouldOverrideUrlLoading", Boolean.class, true);
            }
            return returnValue;
        }

        public void onPageCommitVisible(WebView view, String url) {
            if (WebPlayerView.this.shouldCallSuper("onPageCommitVisible")) {
                super.onPageCommitVisible(view, url);
            }
            if (WebPlayerView.this.shouldSendEvent("onPageCommitVisible")) {
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.WEBPLAYER, WebPlayerEvent.PAGE_COMMIT_VISIBLE, url, WebPlayerView.this.viewId);
            }
        }

        @TargetApi(value=21)
        public WebResourceResponse shouldInterceptRequest(WebView view, WebResourceRequest request2) {
            WebResourceResponse returnValue = null;
            if (WebPlayerView.this.shouldCallSuper("shouldInterceptRequest")) {
                returnValue = super.shouldInterceptRequest(view, request2);
            }
            if (WebPlayerView.this.shouldSendEvent("shouldInterceptRequest")) {
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.WEBPLAYER, WebPlayerEvent.SHOULD_INTERCEPT_REQUEST, request2.getUrl().toString(), WebPlayerView.this.viewId);
            }
            return returnValue;
        }

        public void onFormResubmission(WebView view, Message dontResend, Message resend) {
            if (WebPlayerView.this.shouldCallSuper("onFormResubmission")) {
                super.onFormResubmission(view, dontResend, resend);
            }
            if (WebPlayerView.this.shouldSendEvent("onFormResubmission")) {
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.WEBPLAYER, WebPlayerEvent.FORM_RESUBMISSION, WebPlayerView.this.viewId);
            }
        }

        public boolean shouldOverrideKeyEvent(WebView view, KeyEvent event) {
            Boolean returnValue = false;
            if (WebPlayerView.this.shouldCallSuper("shouldOverrideKeyEvent")) {
                returnValue = super.shouldOverrideKeyEvent(view, event);
            }
            if (WebPlayerView.this.shouldSendEvent("shouldOverrideKeyEvent")) {
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.WEBPLAYER, WebPlayerEvent.SHOULD_OVERRIDE_KEY_EVENT, event.getKeyCode(), event.getAction(), WebPlayerView.this.viewId);
            }
            if (WebPlayerView.this.hasReturnValue("shouldOverrideKeyEvent")) {
                returnValue = (Boolean)WebPlayerView.this.getReturnValue("shouldOverrideKeyEvent", Boolean.class, true);
            }
            return returnValue;
        }

        public void onUnhandledKeyEvent(WebView view, KeyEvent event) {
            if (WebPlayerView.this.shouldCallSuper("onUnhandledKeyEvent")) {
                super.onUnhandledKeyEvent(view, event);
            }
            if (WebPlayerView.this.shouldSendEvent("onUnhandledKeyEvent")) {
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.WEBPLAYER, WebPlayerEvent.UNHANDLED_KEY_EVENT, event.getKeyCode(), event.getAction(), WebPlayerView.this.viewId);
            }
        }
    }

    @TargetApi(value=21)
    private class WebPlayerChromeClient
    extends WebChromeClient {
        private WebPlayerChromeClient() {
        }

        public void onGeolocationPermissionsShowPrompt(String origin, GeolocationPermissions.Callback callback) {
            if (WebPlayerView.this.shouldCallSuper("onGeolocationPermissionsShowPrompt")) {
                super.onGeolocationPermissionsShowPrompt(origin, callback);
            }
            if (WebPlayerView.this.shouldSendEvent("onGeolocationPermissionsShowPrompt")) {
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.WEBPLAYER, WebPlayerEvent.GEOLOCATION_PERMISSIONS_SHOW, origin, WebPlayerView.this.viewId);
            }
        }

        public void onPermissionRequest(PermissionRequest request2) {
            if (WebPlayerView.this.shouldCallSuper("onPermissionRequest")) {
                super.onPermissionRequest(request2);
            }
            if (WebPlayerView.this.shouldSendEvent("onPermissionRequest")) {
                String url = "";
                if (request2 != null && request2.getOrigin() != null) {
                    url = request2.getOrigin().toString();
                }
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.WEBPLAYER, WebPlayerEvent.PERMISSION_REQUEST, url, WebPlayerView.this.viewId);
            }
        }

        public void onProgressChanged(WebView view, int newProgress) {
            if (WebPlayerView.this.shouldCallSuper("onProgressChanged")) {
                super.onProgressChanged(view, newProgress);
            }
            if (WebPlayerView.this.shouldSendEvent("onProgressChanged")) {
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.WEBPLAYER, WebPlayerEvent.PROGRESS_CHANGED, newProgress, WebPlayerView.this.viewId);
            }
        }

        public void onReceivedTitle(WebView view, String title) {
            if (WebPlayerView.this.shouldCallSuper("onReceivedTitle")) {
                super.onReceivedTitle(view, title);
            }
            if (WebPlayerView.this.shouldSendEvent("onReceivedTitle")) {
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.WEBPLAYER, WebPlayerEvent.RECEIVED_TITLE, title, WebPlayerView.this.viewId);
            }
        }

        public void onReceivedIcon(WebView view, Bitmap icon) {
            if (WebPlayerView.this.shouldCallSuper("onReceivedIcon")) {
                super.onReceivedIcon(view, icon);
            }
            if (WebPlayerView.this.shouldSendEvent("onReceivedIcon")) {
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.WEBPLAYER, WebPlayerEvent.RECEIVED_ICON, WebPlayerView.this.viewId);
            }
        }

        public void onReceivedTouchIconUrl(WebView view, String url, boolean precomposed) {
            if (WebPlayerView.this.shouldCallSuper("onReceivedTouchIconUrl")) {
                super.onReceivedTouchIconUrl(view, url, precomposed);
            }
            if (WebPlayerView.this.shouldSendEvent("onReceivedTouchIconUrl")) {
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.WEBPLAYER, WebPlayerEvent.RECEIVED_TOUCH_ICON_URL, url, precomposed, WebPlayerView.this.viewId);
            }
        }

        public void onShowCustomView(View view, WebChromeClient.CustomViewCallback callback) {
            if (WebPlayerView.this.shouldCallSuper("onShowCustomView")) {
                super.onShowCustomView(view, callback);
            }
            if (WebPlayerView.this.shouldSendEvent("onShowCustomView")) {
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.WEBPLAYER, WebPlayerEvent.SHOW_CUSTOM_VIEW, WebPlayerView.this.viewId);
            }
        }

        public void onHideCustomView() {
            if (WebPlayerView.this.shouldCallSuper("onHideCustomView")) {
                super.onHideCustomView();
            }
            if (WebPlayerView.this.shouldSendEvent("onHideCustomView")) {
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.WEBPLAYER, WebPlayerEvent.HIDE_CUSTOM_VIEW, WebPlayerView.this.viewId);
            }
        }

        public boolean onCreateWindow(WebView view, boolean isDialog, boolean isUserGesture, Message resultMsg) {
            Boolean returnValue = false;
            if (WebPlayerView.this.shouldCallSuper("onCreateWindow")) {
                returnValue = super.onCreateWindow(view, isDialog, isUserGesture, resultMsg);
            }
            if (WebPlayerView.this.shouldSendEvent("onCreateWindow")) {
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.WEBPLAYER, WebPlayerEvent.CREATE_WINDOW, isDialog, isUserGesture, resultMsg, WebPlayerView.this.viewId);
            }
            if (WebPlayerView.this.hasReturnValue("onCreateWindow")) {
                returnValue = (Boolean)WebPlayerView.this.getReturnValue("onCreateWindow", Boolean.class, false);
            }
            return returnValue;
        }

        public void onRequestFocus(WebView view) {
            if (WebPlayerView.this.shouldCallSuper("onRequestFocus")) {
                super.onRequestFocus(view);
            }
            if (WebPlayerView.this.shouldSendEvent("onRequestFocus")) {
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.WEBPLAYER, WebPlayerEvent.REQUEST_FOCUS, WebPlayerView.this.viewId);
            }
        }

        public void onCloseWindow(WebView window) {
            if (WebPlayerView.this.shouldCallSuper("onCloseWindow")) {
                super.onCloseWindow(window);
            }
            if (WebPlayerView.this.shouldSendEvent("onCloseWindow")) {
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.WEBPLAYER, WebPlayerEvent.CLOSE_WINDOW, WebPlayerView.this.viewId);
            }
        }

        public boolean onJsAlert(WebView view, String url, String message, JsResult result) {
            Boolean returnValue = false;
            if (WebPlayerView.this.shouldCallSuper("onJsAlert")) {
                returnValue = super.onJsAlert(view, url, message, result);
            }
            if (WebPlayerView.this.shouldSendEvent("onJsAlert")) {
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.WEBPLAYER, WebPlayerEvent.JS_ALERT, url, message, result, WebPlayerView.this.viewId);
            }
            if (WebPlayerView.this.hasReturnValue("onJsAlert")) {
                returnValue = (Boolean)WebPlayerView.this.getReturnValue("onJsAlert", Boolean.class, true);
            }
            return returnValue;
        }

        public boolean onJsConfirm(WebView view, String url, String message, JsResult result) {
            Boolean returnValue = false;
            if (WebPlayerView.this.shouldCallSuper("onJsConfirm")) {
                returnValue = super.onJsConfirm(view, url, message, result);
            }
            if (WebPlayerView.this.shouldSendEvent("onJsConfirm")) {
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.WEBPLAYER, WebPlayerEvent.JS_CONFIRM, url, message, WebPlayerView.this.viewId);
            }
            if (WebPlayerView.this.hasReturnValue("onJsConfirm")) {
                returnValue = (Boolean)WebPlayerView.this.getReturnValue("onJsConfirm", Boolean.class, true);
            }
            return returnValue;
        }

        public boolean onJsPrompt(WebView view, String url, String message, String defaultValue, JsPromptResult result) {
            Boolean returnValue = false;
            if (WebPlayerView.this.shouldCallSuper("onJsPrompt")) {
                returnValue = super.onJsPrompt(view, url, message, defaultValue, result);
            }
            if (WebPlayerView.this.shouldSendEvent("onJsPrompt")) {
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.WEBPLAYER, WebPlayerEvent.JS_PROMPT, url, message, defaultValue, WebPlayerView.this.viewId);
            }
            if (WebPlayerView.this.hasReturnValue("onJsPrompt")) {
                returnValue = (Boolean)WebPlayerView.this.getReturnValue("onJsPrompt", Boolean.class, true);
            }
            return returnValue;
        }

        public boolean onConsoleMessage(ConsoleMessage consoleMessage) {
            Boolean returnValue = false;
            if (WebPlayerView.this.shouldCallSuper("onConsoleMessage")) {
                returnValue = super.onConsoleMessage(consoleMessage);
            }
            if (WebPlayerView.this.shouldSendEvent("onConsoleMessage")) {
                String message = "";
                if (consoleMessage != null) {
                    message = consoleMessage.message();
                }
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.WEBPLAYER, WebPlayerEvent.CONSOLE_MESSAGE, message, WebPlayerView.this.viewId);
            }
            if (WebPlayerView.this.hasReturnValue("onConsoleMessage")) {
                returnValue = (Boolean)WebPlayerView.this.getReturnValue("onConsoleMessage", Boolean.class, true);
            }
            return returnValue;
        }

        public boolean onShowFileChooser(WebView webView, ValueCallback<Uri[]> filePathCallback, WebChromeClient.FileChooserParams fileChooserParams) {
            Boolean returnValue = false;
            if (WebPlayerView.this.shouldCallSuper("onShowFileChooser")) {
                returnValue = super.onShowFileChooser(webView, filePathCallback, fileChooserParams);
            }
            if (WebPlayerView.this.shouldSendEvent("onShowFileChooser")) {
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.WEBPLAYER, WebPlayerEvent.SHOW_FILE_CHOOSER, WebPlayerView.this.viewId);
            }
            if (WebPlayerView.this.hasReturnValue("onShowFileChooser") && (returnValue = (Boolean)WebPlayerView.this.getReturnValue("onShowFileChooser", Boolean.class, true)).booleanValue()) {
                filePathCallback.onReceiveValue(null);
            }
            return returnValue;
        }
    }

    private class WebPlayerDownloadListener
    implements DownloadListener {
        private WebPlayerDownloadListener() {
        }

        public void onDownloadStart(String url, String userAgent, String contentDisposition, String mimetype, long contentLength) {
            if (WebPlayerView.this.shouldSendEvent("onDownloadStart")) {
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.WEBPLAYER, WebPlayerEvent.DOWNLOAD_START, url, userAgent, contentDisposition, mimetype, contentLength, WebPlayerView.this.viewId);
            }
        }
    }

    private class JavaScriptInvocation
    implements Runnable {
        private String _jsString = null;
        private WebView _webView = null;

        public JavaScriptInvocation(String jsString, WebView webView) {
            this._jsString = jsString;
            this._webView = webView;
        }

        @Override
        public void run() {
            block5: {
                if (this._jsString != null) {
                    try {
                        if (Build.VERSION.SDK_INT >= 19) {
                            WebPlayerView.this._evaluateJavascript.invoke((Object)this._webView, this._jsString, null);
                            break block5;
                        }
                        WebPlayerView.this.loadUrl(this._jsString);
                    }
                    catch (Exception e) {
                        DeviceLog.exception("Error while processing JavaScriptString", e);
                    }
                } else {
                    DeviceLog.error("Could not process JavaScript, the string is NULL");
                }
            }
        }
    }
}

