/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.ads.adunit;

import android.os.ConditionVariable;
import com.unity3d.services.core.configuration.Configuration;
import com.unity3d.services.core.misc.Utilities;
import com.unity3d.services.core.request.metrics.AdOperationError;
import com.unity3d.services.core.request.metrics.AdOperationMetric;
import com.unity3d.services.core.request.metrics.SDKMetricsSender;
import com.unity3d.services.core.webview.WebViewApp;
import com.unity3d.services.core.webview.bridge.CallbackStatus;
import java.lang.reflect.Method;
import org.json.JSONObject;

public class AdUnitOpen {
    private static ConditionVariable _waitShowStatus;
    private static Configuration _configuration;
    private static final SDKMetricsSender _sdkMetricsSender;

    public static synchronized boolean open(String placementId, JSONObject options) throws NoSuchMethodException {
        Method showCallback = AdUnitOpen.class.getMethod("showCallback", CallbackStatus.class);
        _waitShowStatus = new ConditionVariable();
        if (_configuration == null) {
            _configuration = new Configuration();
        }
        WebViewApp.getCurrentApp().invokeMethod("webview", "show", showCallback, placementId, options);
        boolean success2 = _waitShowStatus.block((long)_configuration.getShowTimeout());
        _waitShowStatus = null;
        if (!success2) {
            _sdkMetricsSender.sendMetric(AdOperationMetric.newAdShowFailure(AdOperationError.timeout, Long.valueOf(_configuration.getShowTimeout())));
        }
        return success2;
    }

    public static void showCallback(CallbackStatus status) {
        if (_waitShowStatus != null && status.equals((Object)CallbackStatus.OK)) {
            _waitShowStatus.open();
        }
    }

    public static void setConfiguration(Configuration configuration) {
        _configuration = configuration;
    }

    static {
        _sdkMetricsSender = (SDKMetricsSender)Utilities.getService(SDKMetricsSender.class);
    }
}

