/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.ads.metadata;

import android.content.Context;
import com.unity3d.services.core.device.Storage;
import com.unity3d.services.core.device.StorageEvent;
import com.unity3d.services.core.device.StorageManager;
import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.misc.JsonStorage;
import com.unity3d.services.core.misc.Utilities;
import java.util.Iterator;
import org.json.JSONObject;

public class MetaData
extends JsonStorage {
    protected Context _context;
    private String _category;

    public MetaData(Context context) {
        this._context = context.getApplicationContext();
    }

    public void setCategory(String category) {
        this._category = category;
    }

    public String getCategory() {
        return this._category;
    }

    private synchronized boolean set(String key, boolean value) {
        return this.set(key, (Object)value);
    }

    private synchronized boolean set(String key, int value) {
        return this.set(key, (Object)value);
    }

    private synchronized boolean set(String key, long value) {
        return this.set(key, (Object)value);
    }

    @Override
    public synchronized boolean set(String key, Object value) {
        this.initData();
        boolean success2 = false;
        if (super.set(this.getActualKey(key) + ".value", value) && super.set(this.getActualKey(key) + ".ts", System.currentTimeMillis())) {
            success2 = true;
        }
        return success2;
    }

    protected synchronized boolean setRaw(String key, Object value) {
        this.initData();
        boolean success2 = false;
        if (super.set(this.getActualKey(key), value)) {
            success2 = true;
        }
        return success2;
    }

    public void commit() {
        if (StorageManager.init(this._context)) {
            Storage storage = StorageManager.getStorage(StorageManager.StorageType.PUBLIC);
            if (this.getData() != null && storage != null) {
                JSONObject data = this.getData();
                Iterator keys = data.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    Object value = this.get(key);
                    if (storage.get(key) != null && storage.get(key) instanceof JSONObject && this.get(key) instanceof JSONObject) {
                        try {
                            value = Utilities.mergeJsonObjects((JSONObject)value, (JSONObject)storage.get(key));
                        }
                        catch (Exception e) {
                            DeviceLog.exception("Exception merging JSONs", e);
                        }
                    }
                    storage.set(key, value);
                }
                storage.writeStorage();
                storage.sendEvent(StorageEvent.SET, this.getData());
            }
        } else {
            DeviceLog.error("Unity Ads could not commit metadata due to storage error");
        }
    }

    private String getActualKey(String key) {
        String finalKey = key;
        if (this.getCategory() != null) {
            finalKey = this.getCategory() + "." + key;
        }
        return finalKey;
    }
}

