package com.unity3d.ads.core.extensions

import com.unity3d.services.SDKErrorHandler

fun Throwable.retrieveUnityCrashValue(): String = this.stackTrace.find {
    it?.className?.contains(SDKErrorHandler.UNITY_PACKAGE) ?: false
}?.let {
    val className = it.fileName ?: SDKErrorHandler.UNKNOWN_FILE
    val line = it.lineNumber
    "${className}_$line"
} ?: SDKErrorHandler.UNKNOWN_FILE