package com.unity3d.ads.core.domain

import com.google.protobuf.ByteString
import com.unity3d.ads.core.data.datasource.WebviewConfigurationDataSource
import com.unity3d.ads.core.data.repository.CampaignRepository
import gatewayprotocol.v1.UniversalRequestKt.payload
import gatewayprotocol.v1.UniversalRequestOuterClass.UniversalRequest
import gatewayprotocol.v1.adRequest
import com.unity3d.ads.core.data.repository.DeviceInfoRepository
import com.unity3d.ads.core.data.repository.SessionRepository
import com.unity3d.ads.core.data.repository.TcfRepository
import com.unity3d.ads.core.extensions.toISO8859ByteString

import gatewayprotocol.v1.AdRequestOuterClass
import gatewayprotocol.v1.AdRequestOuterClass.AdRequestType
import gatewayprotocol.v1.AdRequestOuterClass.BannerSize


internal class GetAndroidAdRequest(
    private val getUniversalRequestForPayLoad: GetUniversalRequestForPayLoad,
    private val sessionRepository: SessionRepository,
    private val deviceInfoRepository: DeviceInfoRepository,
    private val campaignRepository: CampaignRepository,
    private val webViewConfigurationDataSource: WebviewConfigurationDataSource,
    private val tcfRepository: TcfRepository
) : GetAdRequest {
    override suspend fun invoke(
        placement: String,
        impressionOpportunity: ByteString,
        size: BannerSize?,
    ): UniversalRequest {
        val request = adRequest {
            sessionCounters = sessionRepository.sessionCounters
            staticDeviceInfo = deviceInfoRepository.staticDeviceInfo()
            dynamicDeviceInfo = deviceInfoRepository.dynamicDeviceInfo
            impressionOpportunityId = impressionOpportunity
            placementId = placement
            requestImpressionConfiguration = true

            // scarSignal
            webviewVersion = webViewConfigurationDataSource.get().version
            campaignState = campaignRepository.getCampaignState()

            if (size == null) {
                adRequestType = AdRequestType.AD_REQUEST_TYPE_FULLSCREEN
            } else {
                adRequestType = AdRequestType.AD_REQUEST_TYPE_BANNER
                bannerSize = size
            }

            tcfRepository.tcfString?.let { tcf = it.toISO8859ByteString() }
        }
        val payload = payload {
            adRequest = request
        }
        return getUniversalRequestForPayLoad(payload)
    }


}