package com.unity3d.ads.core.data.datasource

import androidx.lifecycle.Lifecycle
import androidx.lifecycle.LifecycleEventObserver
import androidx.lifecycle.LifecycleOwner
import androidx.lifecycle.ProcessLifecycleOwner
import kotlinx.coroutines.MainScope
import kotlinx.coroutines.flow.MutableStateFlow
import kotlinx.coroutines.launch



class AndroidLifecycleDataSource : LifecycleDataSource, LifecycleEventObserver {
    private val appActive = MutableStateFlow(true)

    init {
        registerAppLifecycle()
    }

    private fun registerAppLifecycle() {
        MainScope().launch {
            ProcessLifecycleOwner.get().lifecycle.addObserver(this@AndroidLifecycleDataSource)
        }
    }

    override fun appIsForeground(): Boolean {
        return appActive.value
    }

    override fun onStateChanged(source: LifecycleOwner, event: Lifecycle.Event) {
        appActive.value = when (event) {
            Lifecycle.Event.ON_STOP -> false
            Lifecycle.Event.ON_START -> true
            else -> appActive.value
        }
    }
}