package com.unity3d.ads.core.data.repository

import com.unity3d.services.UnityAdsConstants
import gateway.v1.OperativeEventRequestOuterClass
import kotlinx.coroutines.channels.BufferOverflow
import kotlinx.coroutines.flow.MutableSharedFlow
import kotlinx.coroutines.flow.asSharedFlow



class OperativeEventRepository {
    private val _operativeEvents = MutableSharedFlow<OperativeEventRequestOuterClass.OperativeEventRequest>(
        replay = UnityAdsConstants.SharedFlow.REPLAY,
        extraBufferCapacity = UnityAdsConstants.SharedFlow.EXTRA_CAPACITY,
        onBufferOverflow = BufferOverflow.DROP_OLDEST
    )
    val operativeEvents = _operativeEvents.asSharedFlow()

    fun addOperativeEvent(operativeEventRequest: OperativeEventRequestOuterClass.OperativeEventRequest) {
        _operativeEvents.tryEmit(operativeEventRequest)
    }
}