package com.unity3d.ads.core.data.repository

import com.unity3d.ads.core.data.datasource.MediationDataSource
import gateway.v1.ClientInfoOuterClass



class AndroidMediationRepository(
    private val mediationDataSource: MediationDataSource
) : MediationRepository {
    override val name: String?
        get() = mediationDataSource.name
    override val version: String?
        get() = mediationDataSource.version

    override val mediationProvider: () -> ClientInfoOuterClass.MediationProvider
        get() = {
            name?.let {
                when {
                    it.startsWith("AppLovinSdk_") -> ClientInfoOuterClass.MediationProvider.MEDIATION_PROVIDER_MAX
                    it.equals("AdMob", ignoreCase = true) -> ClientInfoOuterClass.MediationProvider.MEDIATION_PROVIDER_ADMOB
                    it.equals("MAX", ignoreCase = true) -> ClientInfoOuterClass.MediationProvider.MEDIATION_PROVIDER_MAX
                    it.equals("ironSource", ignoreCase = true) -> ClientInfoOuterClass.MediationProvider.MEDIATION_PROVIDER_LEVELPLAY
                    else -> ClientInfoOuterClass.MediationProvider.MEDIATION_PROVIDER_CUSTOM
                }
            } ?: ClientInfoOuterClass.MediationProvider.MEDIATION_PROVIDER_UNSPECIFIED
        }
}