package com.unity3d.ads.core.data.model


enum class UnityAdsShowResult {
    /**
     * Error related to SDK not initialized
     */
    NOT_INITIALIZED,

    /**
     * Error related to placement not being ready
     */
    NOT_READY,

    /**
     * Error related to the video player
     */
    VIDEO_PLAYER_ERROR,

    /**
     * Error related to invalid arguments
     */
    INVALID_ARGUMENT,

    /**
     * Error related to internet connection
     */
    NO_CONNECTION,

    /**
     * Error related to ad is already being showed
     */
    ALREADY_SHOWING,

    /**
     * Error related to environment or internal services
     */
    INTERNAL_ERROR,

    /**
     * Error related to an Ad being unable to show within a specified time frame
     */
    TIMEOUT,

    SUCCESS,
    FAILURE
}
