/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.banners.api;

import com.unity3d.ads.UnityAds;
import com.unity3d.scar.adapter.common.scarads.ScarAdMetadata;
import com.unity3d.services.ads.operation.load.ILoadOperation;
import com.unity3d.services.ads.operation.load.LoadBannerModule;
import com.unity3d.services.ads.operation.load.LoadBannerOperationState;
import com.unity3d.services.ads.operation.load.LoadOperationState;
import com.unity3d.services.banners.BannerViewCache;
import com.unity3d.services.banners.UnityBannerSize;
import com.unity3d.services.banners.properties.BannerRefreshInfo;
import com.unity3d.services.core.webview.bridge.WebViewCallback;
import com.unity3d.services.core.webview.bridge.WebViewExposed;

public class Banner {
    @WebViewExposed
    public static void load(String bannerViewTypeString, Integer width, Integer height, String bannerAdId, WebViewCallback callback) {
        BannerViewType bannerViewType = BannerViewType.fromString(bannerViewTypeString);
        switch (bannerViewType) {
            case WEB_PLAYER: {
                LoadBannerOperationState state = Banner.getBannerOperationState(bannerAdId);
                if (state == null) break;
                state.setSize(new UnityBannerSize(width, height));
                BannerViewCache.getInstance().loadBanner(state);
                break;
            }
            case UNKNOWN: {
                LoadBannerModule.getInstance().onUnityAdsFailedToLoad(bannerAdId, UnityAds.UnityAdsLoadError.INTERNAL_ERROR, "Unknown banner type");
            }
        }
        callback.invoke(new Object[0]);
    }

    @WebViewExposed
    public static void loadScar(String bannerAdId, String placementId, String queryId, String adUnitId, String adString, Integer width, Integer height, WebViewCallback callback) {
        LoadBannerOperationState state = Banner.getBannerOperationState(bannerAdId);
        if (state == null) {
            callback.invoke(new Object[0]);
            return;
        }
        state.setSize(new UnityBannerSize(width, height));
        ScarAdMetadata scarAdMetadata = new ScarAdMetadata(placementId, queryId, adUnitId, adString, Integer.valueOf(0));
        state.setScarAdMetadata(scarAdMetadata);
        BannerViewCache.getInstance().loadBanner(state);
        callback.invoke(new Object[0]);
    }

    @WebViewExposed
    public static void setRefreshRate(String placementId, Integer refreshRate, WebViewCallback callback) {
        if (placementId != null && refreshRate != null) {
            BannerRefreshInfo.getInstance().setRefreshRate(placementId, refreshRate);
        }
        callback.invoke(new Object[0]);
    }

    private static LoadBannerOperationState getBannerOperationState(String bannerAdId) {
        ILoadOperation operationState = (ILoadOperation)LoadBannerModule.getInstance().get(bannerAdId);
        if (operationState == null || operationState.getLoadOperationState() == null) {
            LoadBannerModule.getInstance().onUnityAdsFailedToLoad(bannerAdId, UnityAds.UnityAdsLoadError.INTERNAL_ERROR, "No operation found for requested banner");
            return null;
        }
        LoadOperationState state = operationState.getLoadOperationState();
        if (state instanceof LoadBannerOperationState) {
            return (LoadBannerOperationState)state;
        }
        LoadBannerModule.getInstance().onUnityAdsFailedToLoad(bannerAdId, UnityAds.UnityAdsLoadError.INTERNAL_ERROR, "Operation state found is not for banner ad");
        return null;
    }

    private static enum BannerViewType {
        WEB_PLAYER,
        UNKNOWN;


        public static BannerViewType fromString(String type) {
            try {
                return BannerViewType.valueOf(type);
            }
            catch (IllegalArgumentException e) {
                return UNKNOWN;
            }
        }
    }
}

